package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.util.Anything;

/**
 * Common constants, some version stuff
 */
public class Common {
	/** 
	 * The default server port.
	 * @serial
	 */
	public static final int SERVER_PORT = 2327;
	/** 
	 *The default host name.
	 * @serial
	 */
	public static final String IPADDR = "localhost";
	/**
	 * The well known object id of the factory. The factory is the object
	 * that can create remote objects. It handles the "create" request.
	 * @serial	 
	 */
	public static final int FACTORY_ID = 1;

	/** 
	 * The major protocol version.
	 * @serial	 
	 */
	public static final int PROTOCOL_VERSION_MAJOR = 9;
	/** 
	 * The minor protocol version.
	 * @serial	 
	 */
	public static final int PROTOCOL_VERSION_MINOR = 0;
	/** 
	 * The release version.
	 * @serial	 
	 */
	public static final String ULC_VERSION = "R3.1";
	public static boolean checkMajorVersion(Anything args) {
		int major= 00;
		if (args != null)
			major= args.get("majorVersion", major);
		if (major == 0 || major != PROTOCOL_VERSION_MAJOR)
			return true;
		return false;
	}
	public static boolean checkMinorVersion(Anything args) {
		int minor= 0;
		if (args != null)
			minor= args.get("minorVersion", minor);
		if (minor != PROTOCOL_VERSION_MINOR)
			return true;
		return false;
	}
static public Object convertAnythingToCollection(Anything a) {
	return a.toCollection();
}
static public Anything convertCollectionToAnything(Vector v) {
	return new Anything(v);
}
static public Object convertFromAnything(Anything a) {
	return a.toObject();
}
/**
 * Convenience method to convert an OrbRequest to a String for logging purposes
 */
static public String convertORBRequestToStringForLog(String prefix, ORBRequest o, String suffix) {
	StringBuffer request = new StringBuffer();
	if (prefix != null) {
		request.append(prefix);
	}
	Anything data = o.getData();
	String req = data.get("req", null);
	String type = "";
	Anything args = data.get("a");
	if (args != null)
		type = args.get("type", "");
	if (req.equals("event")) {
		request.append("event: " + type);
	}
	else
		request.append("request: " + req);
	request.append(", id=");
	request.append(data.get("id", "-1"));
	request.append(", reqId=");
	request.append(o.getRequestId());
	request.append(", replyId=");
	request.append(o.getReplyId());
	request.append(",");
	request.append("Size: " + o.getByteCount());
	if (suffix != null) {
		request.append(",");
		request.append(suffix);
	}
	return request.toString();
}
static public Anything convertToAnything(Object o) {
	return Anything.fromObject(o);
}
	public static String getUlcVersion() {
		return ULC_VERSION;
	}
	public static String getVersion() {
		return PROTOCOL_VERSION_MAJOR + "." + PROTOCOL_VERSION_MINOR;
	}
public static void printULCVersionAndProtocolVersion() {
	System.out.println("ULC Version: " + getUlcVersion() + "  Protocol Version: " + getVersion());
}
}
