package com.ibm.ulc.comm;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */

/**
 * Interface for client/server connections.
 *
 * @see IRequestFilter
 * @see IRequestListener
 * @see UlcConnection
 */
public interface IConnection {
/**
 * Add an IRequestListener that will be notified each time a request is sent or received.
 *
 */
public void addRequestListener(IRequestListener listener);
/**
 * Creates a request. Overridde to define the request to
 * to be created.
 */
public Request createRequest();
/**
 * Return a user defined error message for connection
 * down errors.
 *
 * @since	R3.1
 * @return	the error message as <code>String</code>
 */
public String getConnDownErrorMsg();
/**
 * Returns the IRequestFilter object that is currently configured or null.
 *
 */
public IRequestFilter getRequestFilter();
/**
 * Return the URL of the peer as a string
 */
public String getUrlString();
/**
 * Receives a request and posts it to the request queue.
 * Every request will be passed to registered receive filters first.
 * Return value:
 *		true if request was received
 *		false if request was not received (e.g. filtered out)
 */
public boolean receive(Request request);
/**
 * Remove the previously added  IRequestListener
 *
 */
public void removeRequestListener(IRequestListener listener);
/**
 * Sends a request. Requests are sent asynchronously.
 * Every request will be passed to registered send filters first.
 * Return value:
 *		true if request was sent
 *		false if request was not sent (e.g. filtered out)
 */
public boolean send(Request request);
/**
 * Set a user defined error message for connection
 * down errors.
 *
 * @since	R3.1 
 * @param	errorMessage	The <code>String</code> which should be used as error message
 *
 */
public void setConnDownErrorMsg(String errorMessage);
/**
 * Set the IRequestFilter object that will receive all requests just before they are sent
 * and all requests just after they are recieved.
 *
 */
public void setRequestFilter(IRequestFilter filter);
}
