package com.ibm.ulc.comm;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */

/**
 * An interface to get control over interesting connection
 * events.
 */
public interface IConnectionController {
/**
 * The given connection was created but not yet started.
 *
 * @param connection IConnection
 * @see IConnection
 */
public void connectionCreated(IConnection connection);
/**
 * The given connection was ended.
 * If the end was due to a problem the second argument is non-null
 * and contains the reason for failure.
 * This is a good place to remove yourself from the list
 * of ConnectionControllers. The notification is stable
 * with respect to changing lists.
 *
 * @param connection IConnection
 * @param ex UlcTransportConnection
 * @see com.ibm.ulc.comm.Server
 * @see com.ibm.ulc.comm.IConnection
 * @see com.ibm.ulc.comm.UlcTransportException
 */
public void connectionEnded(IConnection connection, UlcTransportException ex);
/**
 * The given connection was started.
 * If the start was not successful the second argument is non-null
 * and contains the reason for failure.
 *
 * @param connection IConnection
 * @param ex UlcTransportConnection
 * @see IConnection
 * @see UlcTransportException
 */
public void connectionStarted(IConnection connection, UlcTransportException ex);
}
