package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;

/**
 * A listener interface to listen to interesting communication
 * events. This interface will be removed in the next release.
 *
 * @see IConnectionController
 * @see IRequestListener
 */
public interface IORBListener {
	/**
	 * The given connection was added.
	 */
	public void addedConnection(ORBConnection conn);
	/**
	 * A request for the given target with the given arguments was received.
	 */
	public void receivedRequest(ORBConnection conn, int target, String request, Anything args);
	/**
	 * The given connection was removed.
	 */
	public void removedConnection(ORBConnection conn);
	/**
	 * A request for the given target with the given arguments was sent.
	 */
	public void sentRequest(ORBConnection conn, int target, String request, Anything args);
}
