package com.ibm.ulc.corba;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import java.util.*;
import java.io.*;
import java.net.*;
import org.omg.CORBA.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.base.IDefaults;
import com.ibm.ulc.corba.generated.*;


/**
 * An implemention for ULC transports using CORBA.
 *
 * @see UlcTransport
 */
public class UlcCorbaBasedTransport extends UlcTransport {
	// singleton used for ULC server
	static private ORB fgOrb= null;
	private ORB fOrb= fgOrb;	// for compatibility with ULC server
	public UlcCorbaServant fReceiver = null;
	public UlcCorbaObject fSender = null;
	public String fReceiverIOR = null;
/**
 * UlcCorbaTransport constructor.
 */
public UlcCorbaBasedTransport() {
	if (fDebug)
		System.out.println("UlcCorbaBasedTransport().");
}
/**
 * UlcCorbaTransport constructor.
 * Will use the passed in Corba client object.
 * @param sender com.ibm.ulc.corba.UlcCorbaObject
 * @param receiver com.ibm.ulc.corba.UlcCorbaServant
 * @param receiverIOR java.lang.String
 */
public UlcCorbaBasedTransport(UlcCorbaObject sender, UlcCorbaServant receiver, String receiverIOR) {
	if (fDebug)
		System.out.println("UlcCorbaBasedTransport(.,.,.)");
	fSender = sender;
	fReceiver = receiver;
	fReceiverIOR = receiverIOR;
	setUrlString("iiop://localhost#" + fReceiverIOR);
}
/**
 * UlcCorbaTransport constructor.
 * Will use the passed in URL to create a connection to a Corba servant object.
 * @param urlString java.lang.String
 */
public UlcCorbaBasedTransport(String urlString) {
	super(urlString);
	if (fDebug)
		System.out.println("UlcCorbaBasedTransport(). Url=" + getUrlString());
}
protected void createOrb() {
	if (fOrb == null) {
		Properties props= getProperties();	
		if (props.containsKey("Applet")) {
			try {
				java.applet.Applet applet= (java.applet.Applet) props.get("Applet");
				fOrb= ORB.init(applet, props);
			}
			catch (ClassCastException ex){
				fOrb= ORB.init((String[]) null, props);
			}
		}
		else {
			fOrb= ORB.init((String[]) null, props);
		}
	}
}
static protected ORB createOrbSingleton() {
	if (fgOrb == null) {
		Properties props= getProperties();	
		if (props.containsKey("Applet")) {
			try {
				java.applet.Applet applet= (java.applet.Applet) props.get("Applet");
				fgOrb= ORB.init(applet, props);
			}
			catch (ClassCastException ex){
				fgOrb= ORB.init((String[]) null, props);
			}
		}
		else {
			fgOrb= ORB.init((String[]) null, props);
		}
	}
	return fgOrb;
}
protected void flushWriter() {
	if (fDebug)
		System.out.println("UlcCorbaTransport.flushing: " + fWriterQueue.length());
	while (fWriterQueue.length() > 0) {
		try {
			Thread.sleep(250); // wait here to give the writer thread a chance to write all pending requests.
		}
		catch (Exception e) {
		}
	}
}
public String getLocalUrlString() {
	if (fReceiverIOR != null) {
		return "iiop://" + UlcConnection.getLocalHost() + "#" + fReceiverIOR;
	}
	return null;
}
/**
 * Returns the ORB instance for UI (in client mode)
 * and the ORB singleton for ULC server.
 */
public ORB getOrb() {
	return fOrb;
}
protected void handleCorbaExInSendDirect(Exception e) {
	UlcTransportException ulcException= new UlcTransportException(TRANSPORT_EX_CONNECTION_INTERRUPTED, e);
	if (!fTerminated) // we decided here to stop processing!
		// close connection (by posting request)
		if (fConnection != null)
			fConnection.postRequest(new CloseRequest(fConnection, ulcException));
}
/**
 * Initialize connection to peer if necessary.
 */
protected void initPeerConnection() throws UlcTransportException {
	if (fDebug)
		System.out.println("<UlcCorbaBasedTransport.initPeerConnection(). url=" + getUrlString());
	try {
		// create the ORB
		createOrb();
		if (startReceiver() != null)
			startSender();
	} catch (UlcTransportException e) {
		termPeerConnection();
		throw e;
	}
	if (fDebug)
		System.out.println(">UlcCorbaBasedTransport.initPeerConnection(). url=" + getUrlString());
}
/**
 * Does the ULC transport need an asynchronous reader?
 * If it does then this class must override readRequests().
 *
 * Note: Normally this is needed if the LOW LEVEL transport itself
 *       is not synchronous (e.g. SocketTranport).
 */
public boolean readsAsynch() {
	return false;
}
synchronized void receiveBytes(byte[] bytes) {

	// read request from byte array
	ByteArrayInputStream is = new ByteArrayInputStream(bytes);
	com.ibm.ulc.comm.Request request = fConnection.createRequest();
	if (!request.read(is)) {
		System.out.println("@@@@@ invalid request. did not post!");
		request.dump(System.out);
		return;
	}

	// pass request on
	receive(request);
}
protected void sendDirect(com.ibm.ulc.comm.Request r, boolean flush) {
	// prepare byte array
	ByteArrayOutputStream os = new ByteArrayOutputStream();
	r.write(os);
	byte[] bytes = os.toByteArray();

	// send byte array off
	if (fSender != null) {
		try {
			fSender.sendAnyBytes(bytes);
		} catch (org.omg.CORBA.COMM_FAILURE e) {
			handleCorbaExInSendDirect(e);
		} catch (org.omg.CORBA.OBJECT_NOT_EXIST e) {
			handleCorbaExInSendDirect(e);
		}
	}
}
public UlcCorbaServant startReceiver() throws UlcTransportException {
	if (fReceiver == null) {
		// create local servant
		try {
			fReceiver = new UlcCorbaServant();
			fReceiver.setApplicationName("UlcCorbaServant");
			fReceiver.setTransport(this);
			getOrb().connect(fReceiver);
			fReceiverIOR = getOrb().object_to_string(fReceiver);
			if (fDebug)
				System.out.println("UlcCorbaBasedTransport.startReceiver(). fReceiverIOR=" + fReceiverIOR);
		} catch (org.omg.CORBA.SystemException e) {
			if (fDebug) {
				System.out.println("Exception during local servant creation" + e.toString());
				e.printStackTrace();
			}
			String msg = "Could not create Corba servant (Receiver)";
			UlcTransportException ex = new UlcTransportException(msg, TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
	}
	return fReceiver;
}
public UlcCorbaObject startSender() throws UlcTransportException {
	if (fSender == null) {
		// initialize
		if (fReceiver == null)
			startReceiver();
		if (fReceiver == null) {
			if (fDebug)
				System.out.println("UlcCorbaBasedTransport.startSender(). Cannot start receiver!");
			return null;
		}

		String remApplicationName = UlcConnection.getFileFromUrlString(getUrlString());
		if (fDebug)
			System.out.println("UlcCorbaBasedTransport.startSender(). remApplicationName=" + remApplicationName);
		String remFactoryIOR = UlcConnection.getReferenceFromUrlString(getUrlString());
		if (fDebug)
			System.out.println("UlcCorbaBasedTransport.startSender(). remFactoryIOR=" + remFactoryIOR);

		// create client of remote factory from IOR in URL
		UlcCorbaServantFactory factory = null;
		try {
			org.omg.CORBA.Object objRef = getOrb().string_to_object(remFactoryIOR);
			factory = UlcCorbaServantFactoryHelper.narrow(objRef);
		} catch (org.omg.CORBA.SystemException e) {
			if (fDebug) {
				System.out.println("Exception during narrow (remote factory client)" + e.toString());
				e.printStackTrace();
			}
			String msg = "Could not create Corba client (remote factory)";
			UlcTransportException ex = new UlcTransportException(msg, TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}

		// create client
		try {
			// create remote servant and get its IOR
			String remServantIOR = factory.createServant(remApplicationName, fReceiverIOR);
			if (remServantIOR == null || remServantIOR.equals("")) {
				System.out.println("UlcCorbaBasedTransport.startSender(). received null IOR from factory.create!");
				return null;
			}
			if (fDebug)
				System.out.println("UlcCorbaBasedTransport.startSender(). remServantIOR=" + remServantIOR);
			org.omg.CORBA.Object objRef = getOrb().string_to_object(remServantIOR);
			fSender = UlcCorbaObjectHelper.narrow(objRef);
		} catch (org.omg.CORBA.SystemException e) {
			if (fDebug) {
				System.out.println("UlcCorbaBasedTransport.startSender().Exception during creation of client" + e.toString());
				e.printStackTrace();
			}
			String msg = "Could not create Corba servant (Sender)";
			UlcTransportException ex = new UlcTransportException(msg, IDefaults.TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
	}
	return fSender;
}
public void stopReceiver() {
	if (fReceiver != null) {
		// disconnect local servant
		getOrb().disconnect(fReceiver);
		fReceiver._release();
		fReceiverIOR = null;
	}
}
public void stopSender() {
	if (fSender != null)
		fSender._release();
}
protected void termPeerConnection() {
	stopSender();
	fSender = null;
	stopReceiver();
	fReceiver = null;
	if (fOrb != null && fgOrb == null)
		fOrb.shutdown(false);	// true not implemented
	fOrb= null;
}
protected void writeRequests() {
	while (fOrb != null) {
		if (fWriterQueue == null)
			break;
		com.ibm.ulc.comm.Request r = (com.ibm.ulc.comm.Request) fWriterQueue.take(0);
		if (fTerminated)
			break;
		if (r != null)
			sendDirect(r, true);
		if (fTerminated && (fWriterQueue == null || fWriterQueue.length() <= 0))
			break;
	}
	if (fDebug)
		System.out.println("UlcCorbaTransport.writeRequests(). At end");
}
}
