package com.ibm.ulc.corba;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import org.omg.CORBA.*;
import com.ibm.ulc.corba.generated.*;
import com.ibm.ulc.comm.*;

public class UlcCorbaServantFactoryImpl extends _UlcCorbaServantFactoryImplBase {
	protected boolean fDebug= false;

	UlcCorbaTransportServer fTransportServer= null;
public UlcCorbaServantFactoryImpl(UlcCorbaTransportServer server) {
	fDebug= server.isDebugModeOn();
	if (fDebug)
		System.out.println("UlcCorbaServantFactoryImpl()");
	fTransportServer= server;
}
public String createServant(String applicationName, String remServantIOR) {
	if (fDebug)
		System.out.println("Factory.createServant(). appName=" + applicationName + ", remIOR=" + remServantIOR);

	// initialize
	ORB orb= UlcCorbaTransport.createOrbSingleton();
	
	// create local connection servant and IOR
	UlcCorbaServant servant= null;
	try {
		servant= new UlcCorbaServant();
		servant.setApplicationName(applicationName);
		orb.connect(servant);
	}
	catch (org.omg.CORBA.SystemException ex) {
		System.out.println("Factory.createServant(). Exception during local connection servant creation" + ex.toString());
		ex.printStackTrace();
		return null;
	}
	String servantIOR= orb.object_to_string(servant);
	if (fDebug)
		System.out.println("Factory.createServant(). servantIOR=" + servantIOR);
	
	// create remote connection client
	UlcCorbaObject client= null;
	try {
		org.omg.CORBA.Object objRef= orb.string_to_object(remServantIOR);
		client= UlcCorbaObjectHelper.narrow(objRef);
	}
	catch (org.omg.CORBA.SystemException ex) {
		System.out.println("Factory.createServant(). Exception during narrow (remote connection client)" + ex.toString());
		ex.printStackTrace();
		return null;
	}
	if (fDebug)
		System.out.println("Factory.createServant(). remote connection client created");

	// create connection
	UlcCorbaTransport transport=
		fTransportServer.createTransport(client,servant,servantIOR);
	servant.setTransport(transport);
	fTransportServer.createConnection(transport);

	return servantIOR;
}
}
