package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.ULCAlert;

/**
 * This is an 'application-level' Validator, which checks that the
 * input fields of the Account instance have been entered correctly.
 */
public class AccountValidator {
	private Account fAccount;
	private boolean fResult;
	private CustomerInformationEditor fEditor; 
public AccountValidator() {
	fResult= true;
}
public AccountValidator(Account account, CustomerInformationEditor editor) {
	this();
	fAccount= account;
	fEditor= editor;
}
/**
 * Check with the user, whether he really wants to store a non-numeric
 * accoutn number. 
 */
public boolean reconfirmAccountNumberWithUser(String accountString) {
	fEditor.getCustInfo().beep();
	ULCAlert alert= new ULCAlert(fEditor.getShell(), "Account Validation :",
					"Non-numeric Account number (" + accountString + ")", "OK", "Cancel");
	if (alert.ask().equals("OK")) return true;
	else return false;
}
public boolean validate() {
	String accountNumberString= fAccount.getNumber();
	if (!(validateAccountNumber(accountNumberString))) {
		if (!(reconfirmAccountNumberWithUser(accountNumberString))) {
			return false;		
		}
	}
	return true;
}
/**
 * Answer boolean the result of validating the account
 * number field. 
 * For now, the validation simply means checking that
 * the input does not contain non-numeric characters.
 */
public boolean validateAccountNumber(String accountString) {
	try {
		Integer intValue= Integer.valueOf(accountString);
		return true; // could convert successfully
	}
	catch (NumberFormatException e) {
		return false;
	}	
}
}
