package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.application.*;

/**
 * This is the 'tableModel' for the AccountsTable, which maps the protocol
 * expected by ULCModel, to that that needs to be provided by the 'real' 
 * model (i.e. the collection of accounts contained in the customer whose 
 * information is being displayed). 
 *
 * This adapter needs to be a subclass of ULCTableModel,and then, at a
 *	 minimum, needs to implement the two abstract methods from TableModel
 *
 */
public class AccountsAdapter extends ULCTableModel {
	private Vector fAccounts;
	private CustomerInformationEditor fEditor; // for handling edited table values
public AccountsAdapter(CustomerInformationEditor editor) {
	this(editor.getCustInfo().getAccounts());
	fEditor= editor;
}
public AccountsAdapter(Vector accounts) {
	setAccounts(accounts);
}
/** 
 * The given account has been added. 
 * Notify the UI that this one index has been added.
 */
void accountAdded(Account account) {
	int rowIndex= getIndex(account);
	notify(TABLE_MODEL_ROWS_ADDED, null, rowIndex, rowIndex);
}
/** 
 * The given account has been modified. so
 * the corresponding element is updated in the list.
 */
void accountModified(Account account) {
 	int changedAccountIndex= getIndex(account);
	notify(TABLE_MODEL_ROWS_CHANGED, null, changedAccountIndex, changedAccountIndex);
}
public void addAccount(Account account) {
	fAccounts.addElement(account);
	accountAdded(account);
}
/**
 * Keep the index of the account, so as to be able to
 * use it for the 'refresh' notification after the 
 * actual deletion.
 */
public void deleteAccount(Account account) {
	int index= getIndex(account);
	fAccounts.removeElement(account);
	notify(TABLE_MODEL_ROWS_REMOVED, null, index, index);
}
public Vector getAccounts( ) {
	return fAccounts;
}
public int getIndex(Account account) {
	return fAccounts.indexOf(account);
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. 
 *
 * @param row		is the item-index (i.e. the sequence number of the item
 *						(account) being displayed in the ULCTable (view).
 */

public Object getRowAt(int row) {
	Account account = (Account) (fAccounts.elementAt(row));
	return account;
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Use the 'real' model to get the rowCount (as required by the ULCTable).
 */
public int getRowCount() {
	if (fAccounts == null)
		return 0;
	else
		return fAccounts.size();
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. 
 *
 * @param colId 	is the columnIdentifier for a column in the ULCTable. So this
 *						would have a value (say) "Number", "Type" etc.						
 * @param x		is the item-index (i.e. the sequence number of the item
 *						(account) being displayed in the ULCTable (view).
 */
 
public Object getValueAt(String colId, int x) {
	Account account= (Account)(fAccounts.elementAt(x));
	return account.getValueForAttributeName(colId);
}
public void setAccounts(Vector accounts) {
	fAccounts = accounts;
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to set the corresponding
 * value in the 'real' model. 
 *
 * @param value		is the value to be set.
 * @param colId 	is the columnIdentifier for a column in the ULCTable. So this
 *						would have a value (say) "Number", "Type" etc.						
 * @param rowIndex	is the item-index (i.e. the sequence number of the item
 *						(account) being displayed in the ULCTable (view).
 */
 
public void setValueAt(Object value, String colId, int rowIndex) {
	Account account= (Account)(fAccounts.elementAt(rowIndex));
	account.setValueForAttributeName(value, colId);
	if (fEditor != null) {
		fEditor.refreshAccountAdapter();	//to update the new field value
	}
}
}
