package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.*;

/**
 * This class is used for selecting a different customer, using a
 * popup which shows a list of test-customers.
 * On selecting a new customer, the whole view gets refreshed.
 */
public class CustomerSelector {
	protected CustomersAdapter fCustomersAdapter;	// the 'model' for this viewer.
	protected ULCList fList;							// the List widget used for the selection
	protected int fSelectedIndex= 0; 				// the (customer) element selected 
	protected ULCShell fShell;						// the shell for the selection view
	private CustomerInformationEditor fEditor;
public CustomerSelector(CustomerInformationEditor editor) {
	fEditor= editor;
	fShell= new ULCShell("Customer Selector", editor.getShell(), true); // modal
  	getApplication().add(fShell);	// add the receiver's shell to the application.
}
public ULCComponent buildButtonBox() {
	ULCHBox buttonsBox= new ULCHBox(8);

	ULCButton okButton= new ULCButton("OK");
	okButton.setEnabler(fList);
	okButton.addActionListener(new CustomerSelectedAction(this));
	buttonsBox.add("lc", okButton);	
	
	ULCButton cancelButton= new ULCButton("Cancel");
	buttonsBox.add("lc", cancelButton);
	cancelButton.addActionListener(new HideShellAction(this));
	
	return buttonsBox;
}
public ULCApplication getApplication() {
  	return fEditor.getApplication();
}
public Customer getCustomerAtIndex(int selectedCustomerIndex) {
	return (Customer) fCustomersAdapter.fCustomers.elementAt(selectedCustomerIndex);
}
public ULCShell getShell() {
	return fShell;
}
/**
 * After the customer selection has been made, the receiver
 * needs to be hidden away.
 */
void hide() {
	fShell.setVisible(false);
}
/**
 * Build and display the view for selecting a new customer.
 * Note that the customersAdapter is obtained from the editor
 * at this stage (rather than during creation), since we need to
 * display the most recent list of customers (ie. if any changes
 * have been made to the lastName, we need to reflect that in the
 * list.
 */
public void select() {
	if (fList == null) {
		fCustomersAdapter= fEditor.fCustomersAdapter;		// Get the current list of customers.
		fList= new ULCList(fCustomersAdapter, "LastName", 300, 10);
		fList.addSelectionChangedListener(new CustomerSelectedWithoutOkAction(this));	
	
		ULCVBox box= new ULCVBox(8);
		box.add("ee", fList);
		box.add(buildButtonBox());
		fShell.add(box);
	}
	fList.setSelectedIndex(fCustomersAdapter.getIndex(fEditor.getCurrentCustomer()));	
	fShell.setVisible(true);
}
/**
 * The selection has been done, inform the editor to do
 * the needful (for the new customer).
 */
public void setCustomerSelection (int selectedCustomerIndex) {
	Customer newlySelectedCustomer= getCustomerAtIndex(selectedCustomerIndex); 
	fEditor.setCustomerSelection(newlySelectedCustomer);
}
}
