package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.application.*;

/**
 * This is the 'tableModel' for the holding the list of (test) customers.
 * This is required since there is a possibility for the user to change the
 * customer whose details should be viewed.
 */
public class CustomersAdapter extends ULCTableModel {
	protected Vector fCustomers; //This data comes from the 'real' (business) model
public CustomersAdapter() {
	fCustomers= Customer.createTestCustomers();
}
public CustomersAdapter(Vector customers) {
	fCustomers = customers;
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
/** 
 * The given customer has been modified. Update the
 * new values into the list.
 */

void customerModified(Customer customer, NameAddressAdapter newValues) {
 	int changedCustomerIndex= getIndex(customer);

	customer.setLastName(newValues.fLastName);
	customer.setFirstName(newValues.fFirstName);
	customer.setAddress(newValues.fAddress);
						
	fCustomers.setElementAt(customer, changedCustomerIndex);
	notify(TABLE_MODEL_ROWS_CHANGED, null, changedCustomerIndex, changedCustomerIndex);
}
public Vector getCustomers() {
	return fCustomers;
}
public int getIndex(Customer customer) {
	return getCustomers().indexOf(customer);
}
/**
 * Answer the next customer from the receiver's
 * list of customers
 */
public Customer getNextCustomer(Customer customer) {
	int index= getIndex(customer);
	if (index == fCustomers.size()-1) index= -1;
	return (Customer) fCustomers.elementAt(index + 1);
}
/**
 * Answer the previous customer from the receiver's
 * list of customers
 */
public Customer getPreviousCustomer(Customer customer) {
	int index= getIndex(customer);
	if (index == 0) index= fCustomers.size();
	return (Customer) fCustomers.elementAt(index - 1);
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. 
 *
 * @param row		is the item-index (i.e. the sequence number of the item
 *						(account) being displayed in the ULCTable (view).
 */

public Object getRowAt(int row) {
	Customer customer = (Customer) (getCustomers().elementAt(row));
	return customer;
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Use the 'real' model to get the rowCount (as required by the ULCTable).
 */
public int getRowCount() {
	if (getCustomers() == null)
		return 0;
	else
		return getCustomers().size();
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. 
 *
 * @param colId 	is the columnIdentifier for a column in the ULCTable. So this
 *						would have a value (say) "Number", "Type" etc.						
 * @param x		is the item-index (i.e. the sequence number of the item
 *						(account) being displayed in the ULCTable (view).
 */
 
public Object getValueAt(String colId, int x) {
	Customer customer= (Customer)(getCustomers().elementAt(x));
	return customer.getValueForAttributeName(colId);
}
}
