package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.*;

public class NameAddressAdapter extends ULCFormModel {
	String fFirstName;
	String fLastName;
	Address fAddress;
public NameAddressAdapter() {
	super();
}
/**
 * A new customer has been selected. Refresh the details
 * displayed by the receiver.
 */
public NameAddressAdapter(Customer customer) {
	refreshForNewCustomer(customer);
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. So for the name or address, answer these directly 
 * (from the receiver). For any other attributes, assume that these are address-related 
 * attributes, so get them from the address object.
 *
 * @param key 	is the identifier for an attribute in the receiver. So this
 *						would have a value (say) "FirstName", "Street" etc.
 */
 
public Object getValueAt(String key) {
	if (key.equals("FirstName")) return fFirstName;
	if (key.equals("LastName")) return fLastName;
	return fAddress.getValueForAttributeName(key);
}
/**
 * Any changes made to the receiver, have been 
 * 'Cancel'led. So the receiver now just needs to make
 * sure that it's "original" data is being displayed.
 */
 
public void nameAddressModificationCancelled() {
	refresh();
}
/** 
 * Update the UI with the current values
 */
public void refresh() {
	notify(FORM_MODEL_CHANGED,null);
}
/**
 * The customer has changed. Refresh yourself with the
 * values from the (new) customer.
 */
public void refreshForNewCustomer(Customer customer) {
	fFirstName= customer.getFirstName();
	fLastName= customer.getLastName();
	fAddress= customer.getAddress();
}
public void setValueAt(Object object, String key) {
	String newValue = String.valueOf(object);
	if (key.equals("FirstName"))
		fFirstName = newValue;
	if (key.equals("LastName"))
		fLastName = newValue;
	if (key.equals("Street"))
		fAddress.setStreet(newValue);
	if (key.equals("City"))
		fAddress.setCity(newValue);
	if (key.equals("ZipCode"))
		fAddress.setZipCode(newValue);
	if (key.equals("Country"))
		fAddress.setCountry(newValue);
}
}
