package com.ibm.ulc.examples.ManagementStructure;

import java.util.*;
import com.ibm.ulc.application.*;
/**
 * The ManagementStructure application is to be used for representing 
 * the organizational hierarchy of a company as a "tree" structure,
 * using the ULCTree widget. An Employee of the company is a "node" of 
 * this tree, his immediate boss is the Employee's "parent", and all 
 * the employees directly reporting to an Employee are the Employee's 
 * "children" in the tree.
 *
 * This ManagementStructure class is the 'main' class in this application,
 * note that it subclasses ULCContext for this purpose.
 *
 * @see 	#main
 * @see 	#start()
 *
 */
public class ManagementStructure extends ULCContext{

	/**
	 * The main ULC application instance
	 */
	protected ULCApplication 			fApp;

	/**
	 * A separate object to handle the building, editing 
	 * & user-interactions
	 */
	protected ManagementStructureEditor fEditor;
public ManagementStructure() {
	fApp= new ULCApplication(this);
	fEditor= new ManagementStructureEditor(this);
}
/**
 * The ULC.run(args, class) is the useful hook which helps to establish
 * connection to the UIEngine for this application.
 *
 * So every new application could have itself passed 
 * in this way; the ULC.run would then hook back into
 * the start() method, where the actual widget-building
 * can happen.
 *
 * @see			#start()
 */

public static void main (String args[]) {
	ULC.run(args, ManagementStructure.class);
}
public void quit() {
	fApp.terminate();
}
/**
 * The ULC.start() call in main() leads to this point, where
 * one can start with the actual application building.
 * For doing this, pass the receiver application, which will be
 * used by the editor for it's building.
 */
public void start() {
	fEditor.edit(fApp);
}
}
