package com.ibm.ulc.examples.ManagementStructure;

import java.util.*;

public class ManagementStructureModel {
	Employee fCEO;
/**
 * Construct and answer the model to be used for displaying the
 * hierarchy in the organization in the form of a tree structure. 
 * Set the given employee as the CEO of the company.
 */
public ManagementStructureModel(Employee ceo) {
	fCEO= ceo;
	fCEO.setRank(1);			// Ranks are assigned automatically, with the CEO as rank 1.
	fCEO.setBoss(fCEO); 	// He is his own boss !
}
/**
 * Construct and answer the model to be used for displaying the
 * hierarchy in the organization in the form of a tree structure. 
 * This is done by creating the employees of the organization 
 * (the "nodes" of the tree) starting with the CEO of the company
 * (the "root" of the tree).
 */
public static ManagementStructureModel createTestModel() {
	// First the root
	Employee ceo= new Employee("Dave Thomas", "The CEO");
	ceo.setRank(1);
	
	// Now the First-Level Management
	Employee financeInCharge= new Employee("Mr. Finance", "Finance In-charge", ceo);
	Employee adminInCharge= new Employee("Mr. Admin", "Administration In-charge", ceo);
	Employee technicalInCharge= new Employee("Mr. Technical", "Technical In-charge", ceo);
	
	// Now the Second-Level Management
	Employee ottawaDirector= new Employee("Mr. Ottawa TD", "Director, OTI Ottawa", technicalInCharge);
	Employee phoenixDirector= new Employee("Mr. Phoenix TD", "Director, OTI Phoenix", technicalInCharge);
	Employee londonDirector= new Employee("Mr. London TD", "Director, OTI London", technicalInCharge);
	Employee zrichDirector= new Employee("Dr. Erich Gamma", "Director, OTI Zrich", technicalInCharge);

	// And another first-level
	Employee marketingInCharge= new Employee("Mr. Marketing", "Marketing In-charge", ceo);
	
	return new ManagementStructureModel(ceo);
}
public Employee getCEO() {
	return fCEO;
}
}
