package com.ibm.ulc.examples.Pie;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 *
 * A minimal ULC application.
 */

import com.ibm.ulc.util.*;
import com.ibm.ulc.application.*;
/**
 * A minimal ULC application to demonstrate the UI PieChart extension.
 */
public class Pie extends ULCContext {
	private ULCPieChart fPieChart = null;
	private String fLabels[] = {"DEM", "CHF", "UDS", "ITL"};
	private String fColors[] = {"red", "blue", "yellow", "green"};
	private double fValues[] = {0.3, 0.2, 0.4, 0.1};
public static void main(String args[]) {
	ULC.run(args, Pie.class);
}
/**
 * Increment the selected pie segment by 1 every time it is selected.
 */
public void pieSelected(String label) {
	for (int i = 0; i < fLabels.length; i++) {
		if (label.equals(fLabels[i])) {
			fValues[i] = fValues[i] + 1;
			fPieChart.setData(fLabels, fValues, fColors);
		}
	}
}
/**
 * Build the sample ULC application.
 */
public void start() {
	ULCApplication app = new ULCApplication(this);
	ULCShell shell = new ULCShell("Pie Sample", true);
	shell.addWindowClosingListener(new WinCloseAction(app));
	app.add(shell);
	fPieChart = new ULCPieChart(200, 120);
	fPieChart.setData(fLabels, fValues, fColors);
	fPieChart.addActionListener(new PieSelectedAction(this));
	shell.add(fPieChart);
	ULCMenuBar mb = new ULCMenuBar();
	shell.setMenuBar(mb);
	ULCMenu file = new ULCMenu("File");
	mb.add(file);
	file.add("Quit", new QuitAction(app));
	shell.setVisible(true);
}
}
