package com.ibm.ulc.examples.Pie;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/**
 * Implement the ULCPieChart proxy widget that is used to communicate with the UIPieChart extension.
 */
public class ULCPieChart extends ULCComponent {
	/**
	 * Array containing the values of all pie segments.
	 */
	protected double[] fValues;
	/**
	 * Array containing the colors of all pie segments.
	 */
	protected String[] fColors;
	/**
	 * Array containing the labels of all pie segments.
	 */
	protected String[] fLabels;
	/**
	 * Specify the width of the pie chart.
	 */
	int fWidth;
	/**
	 * Specify the height of the pie chart.
	 */
	int fHeight;
/**
 * Create an instance of the pie chart with the default height and width.
 */
public ULCPieChart() {
	this(100, 100);
}
/**
 * Create an instance of the pie chart with the specified height and width.
 */
public ULCPieChart(int w, int h) {
	fWidth = w;
	fHeight = h;
	fColors = new String[0];
	fValues = new double[0];
	fLabels = new String[0];
}
/**
 * Register the specified listener to receive notification every time a pie segment is selected.
 *
 * @param listener	The <code>IActionListener</code> object
 */
public void addActionListener(IActionListener listener) {
	internalAddListener("action", listener);
}
/**
 * Internal method to populate the data values of the pie segments.
 * 
 * @param a com.ibm.ulc.util.Anything
 */
private void fillData(Anything a) {
	Anything colors = new Anything();
	for (int i = 0; i < fColors.length; i++)
		colors.append(new Anything(fColors[i]));
	a.put("colors", colors);
	Anything values = new Anything();
	for (int i = 0; i < fValues.length; i++)
		values.append(new Anything(fValues[i]));
	a.put("values", values);
	Anything labels = new Anything();
	for (int i = 0; i < fLabels.length; i++)
		labels.append(new Anything(fLabels[i]));
	a.put("labels", labels);
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		if (type.equals("action"))
			distributeToListeners("action", new ULCActionEvent(this, args.get("cmd", "???")));
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Unregisters the given observer from the notification list
 * so it will no longer receive action events.
 *
 * @param listener	The widget that was registered to receive my actionEvents.
 */
public void removeActionListener(IActionListener listener) {
	internalRemoveListener("action", listener);
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	a.put("w", fWidth);
	a.put("h", fHeight);
	Anything data = new Anything();
	fillData(data);
	a.put("data", data);
}
/**
 * Set the data for the PieChart
 */
public void setData(String[] labels, double[] values, String[] colors) {
	fValues = new double[values.length];
	fColors = new String[colors.length];
	fLabels = new String[labels.length];
	System.arraycopy(labels, 0, fLabels, 0, labels.length);
	System.arraycopy(values, 0, fValues, 0, values.length);
	System.arraycopy(colors, 0, fColors, 0, colors.length);
	Anything data = new Anything();
	fillData(data);
	sendUI("setData", data);
}
/**
 * Return the fully qualified class path to my proxy class in the UI.
 * Note that this string is case sensitive and specifies the full package path
 * to the UIProxy widget in the UIEngine.
 *
 */
public String typeString() {
	return "com.ibm.ulc.examples.pieExtension.UIPieChart";
}
}
