package com.ibm.ulc.examples.carRental.model;

import java.util.Date;
/**
 * Closed intervals of Dates.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class DateInterval{
	/**
	 * The smallest element of the interval.
	 */ 
	 protected Date fMin = null;
	/**
	 * The largest element of the interval.
	 */ 
	 protected Date fMax = null;
/**
 * DateInterval constructor comment.
 */
public DateInterval() {
	super();
}
/**
 * DateInterval constructor comment.
 * @param min java.lang.Comparable
 * @param max java.lang.Comparable
 */
public DateInterval(Date min, Date max) throws Exception {
	fMin= min;
	fMax= max;
}
/**
 * Answer the maximum of the interval.
 * 
 * Creation date: (07.12.99 18:06:24)
 * @return java.lang.Comparable
 */
public Date getMax() {
	return fMax;
}
/**
 * Answer the minimum of the interval.
 * 
 * Creation date: (07.12.99 18:06:24)
 * @return java.lang.Comparable
 */
public Date getMin() {
	return fMin;
}
/**
 * Answer true, if the parameter lies between the receiver's
 * min and max.
 * 
 * Creation date: (09.12.99 09:48:23)
 * @return boolean
 * @param element Date
 */
public boolean includes(Date element) {
	return !(element.before(fMin)) && !(fMax.before(element));
}
}
