package com.ibm.ulc.examples.carRental.model;

import java.util.Date;

/**
 * Details (time and place) about a date for picking up or returning the car.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class ExchangeDate extends CarRentalObject {
	/**
	 * Where?
	 */
	 protected Location fLocation= null;
	/**
	 * When?/On which day?
	 */
	 protected Date fDate= null;
	/**
	 * When?/ At what time?
	 */
	 protected Date fTime= null;
/**
 * ExchangeDate constructor comment.
 */
public ExchangeDate() {
	super();
}
/**
 * Gets the date property (Date) value.
 * @return The date property value.
 * @see #setDate
 */
public Date getDate() {
	return fDate;
}
/**
 * Gets the location property (com.ibm.ulc.examples.carRental.model.Location) value.
 * @return The location property value.
 * @see #setLocation
 */
public Location getLocation() {
	return fLocation;
}
/**
 * Gets the Time property (Date) value.
 * @return The Time property value.
 * @see #setTime
 */
public Date getTime() {
	return fTime;
}
/**
 * Answer true, if there is enuogh information.
 * Creation date: (07.01.00 11:22:50)
 * @return boolean
 */
public boolean isComplete() {
	return (fDate!=null && fTime!=null && fLocation!=null);
}
/**
 * Sets the date property (Date) value.
 * @param date The new value for the property.
 * @see #getDate
 */
public void setDate(Date date) {
	fDate = date;
}
/**
 * Sets the location property (com.ibm.ulc.examples.carRental.model.Location) value.
 * @param location The new value for the property.
 * @see #getLocation
 */
public void setLocation(Location location) {
	fLocation = location;
}
/**
 * Sets the Time property (Date) value.
 * @param time The new value for the property.
 * @see #getTime
 */
public void setTime(Date time) {
	fTime = time;
}
}
