package com.ibm.ulc.examples.carRental.model;

/**
 * Abstract superclass for all persistent objects
 */
abstract public class PersistentObject extends CarRentalObject {
	
	protected String fId= "";
	
/**
 * Answer a new instance.
 */
public PersistentObject() {
	super();
}
/**
 * Answer a new instance with the given id.
 */
public PersistentObject(String id) {
	super();
	fId = id;
}
/**
 * Two persistent objects are equal, if they have the same ID.
 * @return boolean
 */
public boolean equals(PersistentObject other) {
	return fId == other.getId();
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getId() {
	return fId;
}
/**
 * Two persistent objects are equal, if they have the same ID.
 * @return boolean
 */
public int hashCode() {
	return fId==null ? 7259 : fId.hashCode();
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public void setId() {
}
}
