package com.ibm.ulc.examples.carRental.model;

import java.util.Random;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * This class has only static methods to provide the application with
 * (pseudo) random data.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class RandomDataFactory {

	/**
	 * The basic random number generator (taken from java.util)
	 */
	 protected static Random fgRandom = null;
	/**
	 * The number of letters we allow
	 */
	 protected static int fgLetters;
	/**
	 * The number of letters we allow
	 */
	 protected static String fgVowels;
	/**
	 * The option we have to specify, if we want lowercase strings.
	 */
	 public static final char LOWERCASE_LETTERS= 'a';
	/**
	 * The option we have to specify, if we want uppercase strings.
	 */
	 public static final char UPPERCASE_LETTERS= 'A';
	 
	 static {
		 fgRandom= new Random(3141592653589793L);
		 fgLetters= 'Z'-'A'+1;
		 fgVowels= "aeiou";
	 }
/**
 * RandomDataFactory constructor comment.
 */
public RandomDataFactory() {
	super();
}
/**
 * Answer a boolean, which should be true with probability probability,
 * and false with probability 1-probability.
 * 
 * Creation date: (09.12.99 11:14:13)
 * @return boolean
 * @param probability double
 */
public static boolean booleanTrue(double probability) {
	return fgRandom.nextDouble()<probability;
}
/**
 * Answer an int between 0 and bound-1.
 * 
 * Creation date: (09.12.99 11:14:13)
 * @return int
 * @param bound int
 */
public static int intBelow(int bound) {
	return (int)(fgRandom.nextFloat()*bound);
}
/**
 * Answer a String of length len, consisting of letters 
 * with case specified by casePolicy.
 * 
 * Creation date: (13.12.99 17:04:57)
 * @param len int
 * @param casePolicy char
 */
public static String letterString(int len, char casePolicy) {
	StringBuffer buffer= new StringBuffer(len);
	letterStringOn(len,buffer,casePolicy);
	return buffer.toString();
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (13.12.99 17:04:57)
 * @param len int
 * @param buffer java.lang.StringBuffer
 * @param casePolicy char
 */
public static void letterStringOn(int len, StringBuffer buffer, char casePolicy) {
	for (int i= 0; i<len; i++) {
		char ch= (char) (casePolicy+intBelow(fgLetters));
		buffer.append(ch);
	}
}
/**
 * Pick a random Country among the ones given in the parameter.
 * 
 * Creation date: (13.12.99 14:19:05)
 * @param location com.ibm.ulc.examples.carRental.model.Location
 */
public static Country pickElement(Country[] countries) {
	if (countries.length==0) {
		return null;
	} else {
		return countries[intBelow(countries.length)];
	}
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (13.12.99 16:40:26)
 * @return java.lang.String
 * @param len int
 */
public static String string(int len) {
	StringBuffer buffer= new StringBuffer(len);
	
	for (int i= 0; i<len; i++) {
		buffer.append('a');
	}
	return null;
}
}
