package com.ibm.ulc.examples.carRental.views;

import java.net.URL;
import java.net.MalformedURLException;
import com.ibm.ulc.application.*;

/**
 * Common superclass for all main views used in the application.
 * Sets distroyOnClose and
 * offers some convenience methods.
 */

public abstract class AbstractView extends ULCShell {
	/**
	 * The normal label font.
	 */
	public ULCFont NORMAL_LABEL_FONT = new ULCFont("sansserif.bold", 1, 12);

	/**
	 * The large label font.
	 */
	public ULCFont LARGE_LABEL_FONT = new ULCFont("sansserif", 0, 14);

	/**
	 * The huge label font.
	 */
	public ULCFont HUGE_LABEL_FONT = new ULCFont("sansserif.bold", 1, 18);
/**
 * AbstractView constructor comment.
 */
public AbstractView() {
	super();
}
/**
 * AbstractView constructor comment.
 * @param parent com.ibm.ulc.application.ULCShell
 * @param modal boolean
 * @param visible boolean
 */
public AbstractView(com.ibm.ulc.application.ULCShell parent, boolean modal, boolean visible) {
	super(parent, modal, visible);
}
/**
 * AbstractView constructor comment.
 * @param title java.lang.String
 */
public AbstractView(String title) {
	super(title);
}
/**
 * AbstractView constructor comment.
 * @param title java.lang.String
 * @param parent com.ibm.ulc.application.ULCShell
 * @param modal boolean
 */
public AbstractView(String title, com.ibm.ulc.application.ULCShell parent, boolean modal) {
	super(title, parent, modal);
}
/**
 * AbstractView constructor comment.
 * @param title java.lang.String
 * @param parent com.ibm.ulc.application.ULCShell
 * @param modal boolean
 * @param visible boolean
 */
public AbstractView(String title, com.ibm.ulc.application.ULCShell parent, boolean modal, boolean visible) {
	super(title, parent, modal, visible);
}
/**
 * AbstractView constructor comment.
 * @param title java.lang.String
 * @param closeBoxVeto boolean
 */
public AbstractView(String title, boolean closeBoxVeto) {
	super(title, closeBoxVeto);
}
/**
 * Do the final part initializations here.
 * Creation date: (06.01.00 22:26:47)
 */
protected void finalInitialize() {
	setDestroyOnClose(true);
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	NORMAL_LABEL_FONT = null;
	LARGE_LABEL_FONT = null;
	HUGE_LABEL_FONT = null;
}
/**
 * Answer the awards's logo icon.
 * 
 * Creation date: (27.12.99 16:22:19)
 * @return java.lang.Object
 */
public ULCIcon getAwardLogo() {
	return new ULCIcon(getClass().getResource("/UlcAwardAnimation.gif"));
}
/**
 * Answer the company's logo icon.
 * 
 * Creation date: (27.12.99 16:22:19)
 * @return java.lang.Object
 */
public Object getCompanyLogo() {
	return new ULCIcon(getClass().getResource("/UlcCarRental.gif"));
}
}
