package com.ibm.ulc.examples.carRental.views;

import java.util.Vector;
import com.ibm.ulc.examples.carRental.model.*;

/**
 * Instances can be initialized from the command line arguments
 * and used to configure the application.
 */

public class ApplicationConfiguration extends CarRentalObject {
	/**
	 * The size of the sample data.
	 * @serial
	 */
	 protected int fExampleSize= 1;
	/**
	 * Use test instances as models.
	 * @serial
	 */
	 protected boolean fUseTestInstances= false;
	/**
	 * Turn on application debug mode.
	 * @serial
	 */
	 protected boolean fAppDebug= false;
	/**
	 * The command line switch for the example size.
	 */
	public static String EXAMPLE_SIZE= "-exampleSize";
	/**
	 * The default for the example size.
	 */
	public static String EXAMPLE_SIZE_D= "1";
	/**
	 * The command line switch for the usage of test instances.
	 */
	public static String USE_TEST_INST= "-useTestInstances";
	/**
	 * The default for the test instances switch.
	 */
	public static String USE_TEST_INST_D= "false";
	/**
	 * The command line switch for the usage of test instances.
	 */
	public static String APP_DEBUG_MODE= "-appDebug";
	/**
	 * The default for the test instances switch.
	 */
	public static String APP_DEBUG_MODE_D= "false";
/**
 * ApplicationConfiguration constructor comment.
 */
public ApplicationConfiguration() {
	super();
}
/**
 * Answer an ApplicationConfiguration with the given example size (0<=@exampleSize<=5).
 */
public ApplicationConfiguration(int exampleSize) {
	super();
	fExampleSize= exampleSize;
}
/**
 * Insert the method's description here.
 * Creation date: (25.01.00 14:05:18)
 * @param argv java.lang.String[]
 */
protected String argsGetValueOf(String[] argv, String parameterName, String defaultValue) {
	int argc= argv.length;
	int index= -1;
	for (int i=0; i<argc; i++) {
		if (argv[i].equals(parameterName)) index= i;
	}
	String value= defaultValue;
	if (index>=0 && index+1<argc) {
		value =argv[index+1];
	}
	return value;
}
/**
 * Initialize the receiver from a bunch of strings 
 * (typically the command line arguments).
 *
 * Creation date: (25.01.00 14:05:18)
 * @param argv java.lang.String[]
 */
public void initializeFrom(String[] argv) {
	String strValue;
	
	strValue= argsGetValueOf(argv,EXAMPLE_SIZE,EXAMPLE_SIZE_D);
	int intValue= Integer.parseInt(strValue);
	intValue= 0<=intValue
		? (intValue<=5 ? intValue : 5)
		: 0;
	fExampleSize= intValue;
	
	strValue= argsGetValueOf(argv,USE_TEST_INST, USE_TEST_INST_D);
	boolean boolValue= Boolean.valueOf(strValue).booleanValue();
	fUseTestInstances= boolValue;

	strValue= argsGetValueOf(argv,APP_DEBUG_MODE,APP_DEBUG_MODE_D);
	boolValue= Boolean.valueOf(strValue).booleanValue();
	fAppDebug= boolValue;
}
/**
 * Configure and start up the application.
 */
public void startUp() {
	DataAccessor.instance().initializeData(fExampleSize);
	ReservationView.setUseTestInstance(fUseTestInstances);
	ReservationView.setDebugMode(fAppDebug);
}
}
