package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.application.IUsesVajContext;
import com.ibm.ulc.application.*;

/**
 * Common superclass for all composites used in the notebook pages of the main view;
 * they have to store a reference to the contract spec form model.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class NotebookPageComposite extends AbstractComposite {
	/**
	 * The external model for the ContractSpec displayed in the page
	 * @serial
	 */
	protected ContractSpecFormModel fContractSpecFormModel = null;
/**
 * NotebookPageComposite constructor comment.
 */
public NotebookPageComposite() {
	super();
}
/**
 * NotebookPageComposite constructor comment.
 */
public NotebookPageComposite(IUsesVajContext usesVajContext) {
	super();
	if (usesVajContext != null)
		fVajContext = usesVajContext.getVajContext();
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	fContractSpecFormModel = null;
}
/**
 * Gets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @return The contractSpecFormModel property value.
 * @see #setContractSpecFormModel
 */
public ContractSpecFormModel getContractSpecFormModel() {
	return fContractSpecFormModel;
}
/**
 * Save the changes to the model.
 * Subclasses can override this to save widget state in the model.
 *
 * Creation date: (07.01.00 14:32:52)
 */
public void saveInput() {}
/**
 * Sets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @param contractSpecFormModel The new value for the property.
 * @see #getContractSpecFormModel
 */
public void setContractSpecFormModel(ContractSpecFormModel contractSpecFormModel) {
	fContractSpecFormModel = contractSpecFormModel;
}
}
