package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.ContractSpec;
import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.examples.carRental.model.Location;

/**
 * The composite used to show the pickup details 
 * for the reservation.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class ReturnForm extends NotebookPageComposite {
	private ULCPage ivjFalsePage = null;
	private ULCLabel ivjFillOutLabel = null;
	private ULCLabel ivjPleaseLabel = null;
	private ULCLabel ivjReturnTitleLabel = null;
	private ULCPage ivjTruePage = null;
	private ULCBox ivjVerticalBox = null;
	private ULCBox ivjVerticalBox1 = null;
	private ULCBox ivjBox1 = null;
	private ULCCheckbox ivjReturnSameAsPickupCheckBox = null;
	private ULCPage ivjIsReturnSameAsPickupFalsePage = null;
	private ULCPage ivjIsReturnSameAsPickupTruePage = null;
	private LocationSelectionForm ivjReturnLocationSelectionForm = null;
	private ULCLabel ivjDateLabel = null;
	private ULCField ivjReturnDateField = null;
	private ULCField ivjReturnTimeField = null;
	private ULCLabel ivjTimeLabel = null;
	private ULCPagebook ivjHasPickupInfoPagebook = null;
	private ULCPagebook ivjIsReturnSameAsPickupPagebook = null;
/**
 * ReturnForm constructor comment.
 */
public ReturnForm() {
	super();
/**
 * Warning - This class requires an IUsesVajContext to be initialized properly.
 * This constructor does not have an IUsesVajContext parameter. If it is used,
 * the class will be constructed but it will not be initialized. 
 */
}
/**
 * ReturnForm constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public ReturnForm(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(4, 2);
			ivjBox1.add(0, 0, 2, getReturnSameAsPickupCheckBox());
			ivjBox1.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, 2, getIsReturnSameAsPickupPagebook());
			ivjBox1.add(0, 2, getDateLabel());
			ivjBox1.add(0, 3, getTimeLabel());
			ivjBox1.add(1, 2, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getReturnDateField());
			ivjBox1.add(1, 3, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getReturnTimeField());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the DateLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getDateLabel() {
	if (ivjDateLabel == null) {
		try {
			ivjDateLabel = new com.ibm.ulc.application.ULCLabel("Date");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDateLabel;
}
/**
 * Return the FalsePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getFalsePage() {
	if (ivjFalsePage == null) {
		try {
			ivjFalsePage = new com.ibm.ulc.application.ULCPage("hasPickupInfo=false", getVerticalBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFalsePage;
}
/**
 * Return the FillOutLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getFillOutLabel() {
	if (ivjFillOutLabel == null) {
		try {
			ivjFillOutLabel = new com.ibm.ulc.application.ULCLabel("Fill out the pickup page before");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFillOutLabel;
}
/**
 * Return the Pagebook1 property value.
 * @return com.ibm.ulc.application.ULCPagebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPagebook getHasPickupInfoPagebook() {
	if (ivjHasPickupInfoPagebook == null) {
		try {
			ivjHasPickupInfoPagebook = new com.ibm.ulc.application.ULCPagebook();
			ivjHasPickupInfoPagebook.setFormAttributeName("hasPickupInfo");
			ivjHasPickupInfoPagebook.addPage(getTruePage());
			ivjHasPickupInfoPagebook.addPage(getFalsePage());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHasPickupInfoPagebook;
}
/**
 * Return the IsReturnSameAsPickupFalsePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getIsReturnSameAsPickupFalsePage() {
	if (ivjIsReturnSameAsPickupFalsePage == null) {
		try {
			ivjIsReturnSameAsPickupFalsePage = new com.ibm.ulc.application.ULCPage("false", getReturnLocationSelectionForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjIsReturnSameAsPickupFalsePage;
}
/**
 * Return the Pagebook2 property value.
 * @return com.ibm.ulc.application.ULCPagebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPagebook getIsReturnSameAsPickupPagebook() {
	if (ivjIsReturnSameAsPickupPagebook == null) {
		try {
			ivjIsReturnSameAsPickupPagebook = new com.ibm.ulc.application.ULCPagebook();
			ivjIsReturnSameAsPickupPagebook.setFormAttributeName("isReturnSameAsPickup");
			ivjIsReturnSameAsPickupPagebook.addPage(getIsReturnSameAsPickupTruePage());
			ivjIsReturnSameAsPickupPagebook.addPage(getIsReturnSameAsPickupFalsePage());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjIsReturnSameAsPickupPagebook;
}
/**
 * Return the IsReturnSameAsPickupTruePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getIsReturnSameAsPickupTruePage() {
	if (ivjIsReturnSameAsPickupTruePage == null) {
		try {
			ivjIsReturnSameAsPickupTruePage = new com.ibm.ulc.application.ULCPage("true", null);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjIsReturnSameAsPickupTruePage;
}
/**
 * Return the PleaseLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getPleaseLabel() {
	if (ivjPleaseLabel == null) {
		try {
			ivjPleaseLabel = new com.ibm.ulc.application.ULCLabel("Please");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPleaseLabel;
}
/**
 * Return the ReturnDateField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getReturnDateField() {
	if (ivjReturnDateField == null) {
		try {
			com.ibm.ulc.application.ULCDateValidator ivjLocalDataType;
			ivjLocalDataType = new com.ibm.ulc.application.ULCDateValidator();
			ivjLocalDataType.setFormatString("dd.MM.yyyy");
			ivjReturnDateField = new com.ibm.ulc.application.ULCField();
			ivjReturnDateField.setFormAttributeName("returnDate");
			ivjReturnDateField.setDataType(ivjLocalDataType);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnDateField;
}
/**
 * Return the ReturnLocationSelectionForm property value.
 * @return com.ibm.ulc.examples.carRental.views.LocationSelectionForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private LocationSelectionForm getReturnLocationSelectionForm() {
	if (ivjReturnLocationSelectionForm == null) {
		try {
			ivjReturnLocationSelectionForm = new com.ibm.ulc.examples.carRental.views.LocationSelectionForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnLocationSelectionForm;
}
/**
 * Return the ReturnSameAsPickupCheckBox property value.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCCheckbox getReturnSameAsPickupCheckBox() {
	if (ivjReturnSameAsPickupCheckBox == null) {
		try {
			ivjReturnSameAsPickupCheckBox = new com.ibm.ulc.application.ULCCheckbox();
			ivjReturnSameAsPickupCheckBox.setFormAttributeName("isReturnSameAsPickup");
			ivjReturnSameAsPickupCheckBox.setLabel("Return location same as pickup");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnSameAsPickupCheckBox;
}
/**
 * Return the ReturnTimeField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getReturnTimeField() {
	if (ivjReturnTimeField == null) {
		try {
			com.ibm.ulc.application.ULCDateValidator ivjLocalDataType1;
			ivjLocalDataType1 = new com.ibm.ulc.application.ULCDateValidator();
			ivjLocalDataType1.setFormatString("HH:mm:ss|HH:mm|HH");
			ivjReturnTimeField = new com.ibm.ulc.application.ULCField();
			ivjReturnTimeField.setFormAttributeName("returnTime");
			ivjReturnTimeField.setDataType(ivjLocalDataType1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnTimeField;
}
/**
 * Return the ReturnTitleLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getReturnTitleLabel() {
	if (ivjReturnTitleLabel == null) {
		try {
			ivjReturnTitleLabel = new com.ibm.ulc.application.ULCLabel("Returning up the car: where & when?");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnTitleLabel;
}
/**
 * Return the TimeLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getTimeLabel() {
	if (ivjTimeLabel == null) {
		try {
			ivjTimeLabel = new com.ibm.ulc.application.ULCLabel("Time (HH:mm:ss)");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTimeLabel;
}
/**
 * Return the TruePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getTruePage() {
	if (ivjTruePage == null) {
		try {
			ivjTruePage = new com.ibm.ulc.application.ULCPage("hasPickupInfo=true", getBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTruePage;
}
/**
 * Return the Vertical Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox() {
	if (ivjVerticalBox == null) {
		try {
			ivjVerticalBox = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjVerticalBox.add(0, 0, getReturnTitleLabel());
			ivjVerticalBox.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getHasPickupInfoPagebook());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox;
}
/**
 * Return the Vertical Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox1() {
	if (ivjVerticalBox1 == null) {
		try {
			ivjVerticalBox1 = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjVerticalBox1.add(0, 0, getPleaseLabel());
			ivjVerticalBox1.add(0, 1, getFillOutLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox1;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getVerticalBox());
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	finalInitialize();
	// user code end
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new ReturnForm(context);
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCField
 */
ULCField pGetReturnDateField() {
	return getReturnDateField();
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.LocationSelectionForm
 */
LocationSelectionForm pGetReturnLocationSelectionForm() {
	return getReturnLocationSelectionForm();
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
ULCCheckbox pGetReturnSameAsPickupCheckBox() {
	return getReturnSameAsPickupCheckBox();
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCField
 */
ULCField pGetReturnTimeField() {
	return getReturnTimeField();
}
/**
 * Save the changes to the model.
 * Subclasses can override this to save widget state in the model.
 *
 * Creation date: (07.01.00 14:32:52)
 */
public void saveInput() {
	Location selected= getReturnLocationSelectionForm().getSelectedLocation();
	ContractSpec contract= fContractSpecFormModel.getContractSpec();
	
	contract.getReturnDetails().setLocation(selected);
	contract.makeConsistent();
}
/**
 * Sets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @param contractSpecFormModel The new value for the property.
 * @see #getContractSpecFormModel
 */
public void setContractSpecFormModel(ContractSpecFormModel contractSpecFormModel) {
	fContractSpecFormModel = contractSpecFormModel;
	//
	getHasPickupInfoPagebook().setFormModel(fContractSpecFormModel);
	getIsReturnSameAsPickupPagebook().setFormModel(fContractSpecFormModel);
	getReturnSameAsPickupCheckBox().setFormModel(fContractSpecFormModel);
	getReturnDateField().setFormModel(fContractSpecFormModel);
	getReturnTimeField().setFormModel(fContractSpecFormModel);
	//
	updateContractSpecFormModelChanged();
}
/**
 * Set the fonts of the subparts.
 * Creation date: (06.01.00 22:27:49)
 */
protected void setFonts() {
	super.setFonts();
	getReturnTitleLabel().setFont(HUGE_LABEL_FONT);
	//
	getPleaseLabel().setFont(LARGE_LABEL_FONT);
	//
	getReturnSameAsPickupCheckBox().setFont(NORMAL_LABEL_FONT);
	getDateLabel().setFont(NORMAL_LABEL_FONT);
	getTimeLabel().setFont(NORMAL_LABEL_FONT);
}
/**
 * Insert the method's description here.
 * Creation date: (06.01.00 23:50:16)
 * @param treeModel com.ibm.ulc.application.ULCTreeTableModel
 */
public void setLocationsTreeModel(ULCTreeTableModel treeModel) {
	getReturnLocationSelectionForm().setLocationTreeModelThis(treeModel);
}
/**
 * Set the reference to the parent shell of the receiver;
 * subclasses should override this to propagate the reference
 * to child composites.
 *
 * Creation date: (11.01.00 11:27:09)
 * @param shell com.ibm.ulc.application.ULCShell
 */
public void setShell(ULCShell shell) {
	fShell= shell;
	getReturnLocationSelectionForm().setShell(shell);
}
/**
 * Set the size of notebooks and pagebooks,
 * which is mandatory!
 *
 * Creation date: (06.01.00 22:27:49)
 */
protected void sizeNoteAndPageBooks() {
	/* Setting the layout parameters with the property sheets
	 * in the composition editor, makes the edit time layout
	 * too poor: we have to set H and W by code
	 */
	getHasPickupInfoPagebook().setHeight(368); 
	getHasPickupInfoPagebook().setWidth(424);
	getIsReturnSameAsPickupPagebook().setHeight(266);
	getIsReturnSameAsPickupPagebook().setWidth(396);
}
/**
 * The ContractSpecFormModel has been set: do the updates to the view.
 * Creation date: (06.01.00 22:27:49)
 */
protected void updateContractSpecFormModelChanged() {
	Location rLoc= getContractSpecFormModel().getContractSpec().getReturnDetails().getLocation();
	getReturnLocationSelectionForm().setSelectedLocation(rLoc);
}
}
