package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import java.util.Vector;
public class UlxBallot {
	boolean fDoit = true;
/**
 * Create and answer a new ballot object
 */
public UlxBallot() {
}
/**
 * handle the quit event for @application. Let every one of the @windows vote.
 */
void handleQuitRequest(UlxSystem system, Vector windows) {
	for (int i = 0; i < windows.size(); i++) {
		UlxWindowAbstract window = (UlxWindowAbstract) windows.elementAt(i);
		Vector listeners = window.getListenersFor("windowClosing");
		if (!pollOnWindowClose(window, listeners))
			return;
	}
	system.getApplication().terminate();
}
/**
 * Create and answer a new ballot object
 */
boolean handleWindowClosingEvent(UlxWindowAbstract window, java.util.Vector voters) {
	boolean result = pollOnWindowClose(window, voters);
	if (result)
		window.setVisible(false);
	return (!result);
}
/**
 * Create and answer a new ballot object
 */
private boolean pollOnWindowClose(UlxWindowAbstract window, java.util.Vector voters) {
	for (int i = 0; i < voters.size(); i++) {
		try {
			if (!((IWindowCloseVoter) voters.elementAt(i)).voteOnWindowClose(window))
				return false;
		}
		catch (Throwable t) {
		}
	}
	//window.setVisible(false);
	return true;
}
}
