package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import com.ibm.ulc.application.ULCIcon;
public class UlxContainer extends UlxModel {
	private UlxContainer fieldContainer = null;
	private UlxContainer[] fieldContained = new UlxContainer[0];
	private String fieldName = new String();
	private ULCIcon fieldIcon = null;
/**
 * UlxModel constructor comment.
 */
public UlxContainer() {
	super();
}
/**
 * Gets the contained property (com.ibm.ulc.test.UlxGeographicEntity[]) value.
 * @return The contained property value.
 * @see #setContained
 */
public void addContained(UlxContainer contained) {
	if (!UlxCollection.contains(fieldContained, contained)) {
		UlxContainer[] newContained = new UlxContainer[fieldContained.length + 1];
		UlxCollection.add(newContained, fieldContained, contained);
		setContained(newContained);
	}
}
/**
 * Gets the contained index property (com.ibm.ulc.test.UlxGeographicEntity) value.
 * @return The contained property value.
 * @param index The index value into the property array.
 * @see #setContained
 */
public int getChildCount() {
	return getContained().length;
}
/**
 * Gets the contained property (com.ibm.ulc.test.UlxGeographicEntity[]) value.
 * @return The contained property value.
 * @see #setContained
 */
public UlxContainer[] getContained() {
	return fieldContained;
}
/**
 * Gets the contained index property (com.ibm.ulc.test.UlxGeographicEntity) value.
 * @return The contained property value.
 * @param index The index value into the property array.
 * @see #setContained
 */
public UlxContainer getContained(int index) {
	return getContained()[index];
}
/**
 * Gets the location property (com.ibm.ulc.test.UlxGeographicEntity) value.
 * @return The location property value.
 * @see #setLocation
 */
public UlxContainer getContainer() {
	return fieldContainer;
}
/**
 * Gets the icon property (com.ibm.ulc.application.ULCIcon) value.
 * @return The icon property value.
 * @see #setIcon
 */
public ULCIcon getIcon() {
	return fieldIcon;
}
/**
 * getListString method comment.
 */
public String getListString() {
	if (getContainer() == null)
		return getName();
	else
		return getName() + "<-" + getContainer().getListString();
}
/**
 * Gets the name property (java.lang.String) value.
 * @return The name property value.
 * @see #setName
 */
public String getName() {
	return fieldName;
}
/**
 * Gets the contained property (com.ibm.ulc.test.UlxGeographicEntity[]) value.
 * @return The contained property value.
 * @see #setContained
 */
public void removeContained(UlxContainer contained) {
	if (UlxCollection.contains(fieldContained, contained)) {
		UlxContainer[] newContained = new UlxContainer[fieldContained.length - 1];
		UlxCollection.remove(newContained, fieldContained, contained);
		setContained(newContained);
	}
}
/**
 * Sets the contained property (com.ibm.ulc.test.UlxGeographicEntity[]) value.
 * @param contained The new value for the property.
 * @see #getContained
 */
public void setContained(UlxContainer[] contained) {
	com.ibm.ulc.test.UlxContainer[] oldValue = fieldContained;
	for (int i = 0; i < contained.length; i++)
		contained[i].setContainer(this);
	fieldContained = contained;
	firePropertyChange("contained", oldValue, contained);
}
/**
 * Sets the contained index property (com.ibm.ulc.test.UlxGeographicEntity[]) value.
 * @param index The new value for the property.
 * @param contained The new value for the property.
 * @see #getContained
 */
public void setContained(int index, UlxContainer contained) {
	Integer oldSize = new Integer(getChildCount());
	com.ibm.ulc.test.UlxContainer[] oldValue = fieldContained;
	fieldContained[index] = contained;
	firePropertyChange("contained", oldValue, fieldContained);
	firePropertyChange("childCount", new Integer(getChildCount()), oldSize);
}
/**
 * Sets the location property (com.ibm.ulc.test.UlxGeographicEntity) value.
 * @param location The new value for the property.
 * @see #getLocation
 */
public void setContainer(UlxContainer container) {
	if (fieldContainer != null) {
		fieldContainer.removeContained(this);
	}
	UlxContainer oldValue = fieldContainer;
	fieldContainer = container;
	firePropertyChange("container", oldValue, container);
	//container.addContained(this);
}
/**
 * Sets the icon property value.
 * @param icon The new value for the property.
 * @see #getIcon
 */
public void setIcon(ULCIcon icon) {
	ULCIcon oldValue = fieldIcon;
	fieldIcon = icon;
	firePropertyChange("icon", oldValue, icon);
}
/**
 * Sets the name property (java.lang.String) value.
 * @param name The new value for the property.
 * @see #getName
 */
public void setName(String name) {
	String oldValue = fieldName;
	fieldName = name;
	firePropertyChange("name", oldValue, name);
	IUlxModel[] children = getContained();
	listStringChanged();
	for (int i = 0; i < children.length; i++)
		children[i].listStringChanged();
}
}
