package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import java.util.EventListener;
class UlxEventListenerList {
	/* An empty array to be shared by all empty listener lists*/
	private final static EventListener[] EMPTY_ARRAY = new EventListener[0];
	/* The list of ListenerType - Listener pairs */
	protected transient EventListener[] fListenerList = EMPTY_ARRAY;
	protected transient Class[] fClassList = null;
/**
 * UlxEventListenerList constructor comment.
 */
public UlxEventListenerList() {
	super();
}
/**
 * Add the listener as a listener of the specified type.
 * @param type 			the type of the listener to be added
 * @param listener	 	the listener to be added
 */
public synchronized void add(Class type, EventListener listener) {
	if (fListenerList == EMPTY_ARRAY) {
		fListenerList = new EventListener[] {listener};
		fClassList = new Class[] {type};
	} else {
		int i = getListenerCount();
		EventListener[] listeners = new EventListener[i + 1];
		System.arraycopy(fListenerList, 0, listeners, 0, i);
		listeners[i] = listener;
		Class[] classes = new Class[i + 1];
		System.arraycopy(fClassList, 0, classes, 0, i);
		classes[i] = type;
		fListenerList = listeners;
		fClassList = classes;
	}
}
/**
 * answer the number of listeners currently defined
 */
int getListenerCount() {
	return fListenerList.length;
}
/**
 * answer the number of listeners currently defined
 */
int getListenerCount(Class cls) {
	int answer = 0;
	for (int i = 0; i < fListenerList.length; i++) {
		if (fClassList[i] == cls)
			answer++;
	}
	return answer;
}
/**
 * answer the number of listeners currently defined
 */
Object[] getListeners() {
	return fListenerList;
}
/**
 * answer the number of listeners currently defined
 */
EventListener[] getListeners(Class cls) {
	int count = 0;
	EventListener[] answer = new EventListener[getListenerCount(cls)];
	for (int i = 0; i < answer.length; i++) {
		if (fClassList[i] == cls)
			answer[count++] = fListenerList[i];
	}
	return answer;
}
/**
 * Add the listener as a listener of the specified type.
 * @param type 			the type of the listener to be added
 * @param listener	 	the listener to be added
 */
public synchronized void remove(Class type, EventListener listener) {
	for (int i = 0; i < fListenerList.length; i++) {
		if (fListenerList[i] == listener) {
			if (fClassList[i] == type) {
				EventListener[] listeners = new EventListener[fListenerList.length - 1];
				Class[] classes = new Class[listeners.length];
				System.arraycopy(fListenerList, 0, listeners, 0, i);
				System.arraycopy(fClassList, 0, classes, 0, i);
				if (i < listeners.length) {
					System.arraycopy(fListenerList, i + 1, listeners, i, listeners.length - 1);
					System.arraycopy(fClassList, i + 1, classes, i, classes.length - 1);
				}
				if (listeners.length == 0) {
					fListenerList = EMPTY_ARRAY;
					fClassList = null;
				} else {
					fListenerList = listeners;
					fClassList = classes;
				}
			}
		}
	}
}
}
