package com.ibm.ulc.test;

/**
 * This class is used in the UI of this package.
 *
 * It wraps a single test composite (subclass of UlxAbstractTestComposite).
 */
import com.ibm.ulc.application.ULCFormModel;
import com.ibm.ulc.application.ULCVajContext;
import com.ibm.ulc.application.ULCApplication;
import com.ibm.ulc.util.ITableRow;
public class UlxTest implements ITableRow {
	int fid = -1;
	String fTestClassName = "";
	String fPackageName = "";
	String fDescription = "";
	String[] fTestedClasses = new String[0];
	String[] fTestedAPI = new String[0];
	String[] fTestCategories = new String[0];
	String[] fTestedPRs = new String[0];
	String fAuthor = "";
	String fTabString = "";
	UlxSystem fSystem;
	IUlxTestListener[] fListeners = new IUlxTestListener[0];
	private int fState = STATE_UNDEFINED;
	static int STATE_UNDEFINED = 0;
	static int STATE_CLEAN = 1;
	static int STATE_DIRTY = 2;
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
UlxTest() {
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
UlxTest(UlxSystem system) {
	super();
	fSystem = system;
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
UlxTest(UlxSystem system, Class testComponent) {
	this(system);
	setComponent(testComponent);
}
/**
 * Answer the current author of the receiver's test
 *
 * @return String
 */
void addListener(IUlxTestListener listener) {
	int newLength = fListeners.length + 1;
	IUlxTestListener[] newList = new IUlxTestListener[newLength];
	if (newLength > 1) {
		// not the first listener
		System.arraycopy(fListeners, 0, newList, 0, fListeners.length);
	}
	fListeners = newList;
	fListeners[newLength - 1] = listener;
}
/**
 * Answer true, if the receiver's test class can be run
 */
public boolean canRun() {
	return ((!this.isNewTest()) && (true));
}
/**
 * Answer true, if the receiver's test class can be run
 */
public void edit() {
	UlxWindowTestEditor editor = new UlxWindowTestEditor(fSystem.getContext());
	ULCApplication app = new ULCApplication(fSystem.getContext());
	app.add(editor);
	editor.setTest(this);
	editor.setVisible(true);
}
/**
 * Answer the current author of the receiver's test
 *
 * @return String
 */
String getAuthor() {
	return fAuthor;
}
ULCVajContext getContext() {
	return fSystem.getContext();
}
/**
 * Answer the current description of the receiver's test
 *
 * @return String
 */
String getDescription() {
	return fDescription;
}
int getIdentifier() {
	return fid ;
}
/**
 * Answer a string for the receiver for display in a list
 *
 * @return String
 */
String getListString() {
	return getQualifiedClassName();
}
/**
 * set the class name of the receiver's test
 *
 * @return String
 */
String getQualifiedClassName() {
	return getTestPackageName() + "." + getTestClassName();
}
/**
 * answer a summary of the receiver
 *
 * @return String
 */
String getSummary() {
	return 
		"Test Class Name:   " + getQualifiedClassName() + "\n" +
		"Description:" + "\n" +
		getDescription() + "\n\n" +
		"Tested Classes:    " + toString(getTestedClasses(), ", ") + "\n" +
		"Tested API:        " + toString(getTestedAPI(), ", ") + "\n" +
		"Tested Categories: " + toString(getTestCategories(), ", ") + "\n" +
		"Tested PRs:        " + toString(getTestedPRs(), ", ") + "\n" +
		"Test Author:       " + getAuthor() + "\n";
}
/**
 * answer the index of the reciever in the system's collection of UlxTests
 *
 * @return int
 */
int getSystemIndex() {
	return fSystem.indexOf(this);
}
/**
 * Answer the list of test categories covered by the receiver's test.
 *
 * @return String[]
 */
String[] getTestCategories() {
	return fTestCategories;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
Class getTestClass() {
	Class answer = null;
	try {
		answer = Class.forName(getQualifiedClassName());
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * set the class name of the receiver's test
 *
 * @return String
 */
String getTestClassName() {
	return fTestClassName;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
UlxAbstractTestComposite getTestComposite(int tabPlacement) {
	Class thisClass = getTestClass();
	if (thisClass == null)
		return null;
	UlxAbstractTestComposite answer = null;
	try {
		java.lang.reflect.Constructor constructor = thisClass.getConstructor(new Class[] {ULCVajContext.class});
		answer = (UlxAbstractTestComposite) constructor.newInstance(new Object[] {getContext()});
	} catch (Throwable t1) {
		try {
			java.lang.reflect.Constructor constructor = thisClass.getConstructor(new Class[] {com.ibm.ulc.application.IUsesVajContext.class});
			answer = (UlxAbstractTestComposite) constructor.newInstance(new Object[] {getContext()});
		} catch (Throwable t2) {
			t2.toString();
		}
	}
	return answer;
}
/**
 * Answer the list of methods tested by the receiver's test.
 *
 * @return String[]
 */
String[] getTestedAPI() {
	return fTestedAPI;
}
/**
 * set the class name of the receiver's test
 *
 * @return String
 */
Class getTestedClass() {
	try {
		return Class.forName(getQualifiedClassName());
	} catch (Throwable t) {
		return null;
	}
}
/**
 * Answer the list of classes tested by the receiver's test
 *
 * @return String[]
 */
String[] getTestedClasses() {
	return fTestedClasses;
}
/**
 * Answer the list of problem reports (PR) tested by the receiver's test.
 *
 * @return String[]
 */
String[] getTestedPRs() {
	return fTestedPRs;
}
/**
 * set the package name of the receiver's test
 *
 * @return String
 */
String getTestPackageName() {
	return fPackageName;
}
/**
 * Answer the String displayed on the reciever's page
 *
 * @return String
 */
String getTestPageTabString() {
	return fTabString;
}
/**
 * Override this method to return the requested value for the given key.
 *
 * @param formAttributeName 	The key at which the object is.
 */
public Object getValueAt(String formAttributeName) {
	if (formAttributeName.equals("testClassName"))
		return getTestClassName();
	if (formAttributeName.equals("testPackageName"))
		return getTestPackageName();
	if (formAttributeName.equals("author"))
		return getAuthor();
	if (formAttributeName.equals("tabString"))
		return getTestPageTabString();
	if (formAttributeName.equals("description"))
		return getDescription();
	if (formAttributeName.equals("summary"))
		return getSummary();
	if (formAttributeName.equals("listString"))
		return getListString();


	if (formAttributeName.equals("testedClasses"))
		return getTestedClasses();
	if (formAttributeName.equals("testedAPI"))
		return getTestedAPI();
	if (formAttributeName.equals("testedPRs"))
		return getTestedPRs();
	if (formAttributeName.equals("testCategories"))
		return getTestCategories();
		
	if (formAttributeName.equals("testedClassesString"))
		return toString(getTestedClasses(), ", ");
	if (formAttributeName.equals("testedAPIString"))
		return toString(getTestedAPI(), ", ");
	if (formAttributeName.equals("testedPRsString"))
		return toString(getTestedPRs(), ", ");
	if (formAttributeName.equals("testCategoriesString"))
		return toString(getTestCategories(), ", ");
	return null;
}
boolean isApiTest() {
	return false;
}
boolean isClassTest() {
	return false;
}
/**
 * Answer true if the receiver's data is complete.
 * If some information is missing, the receiver cannot be stored.
 *
 * @return boolean 
 */
public boolean isComplete() {
	return 
	(	(fTestClassName.length() > 0) &&
		(fDescription.length() > 0) &&
		(	(fTestedClasses.length > 0) ||
		 	(fTestedAPI.length > 0) ||
		 	(fTestedPRs.length > 0)
		)
	);
}
boolean isComposedTest() {
	return false;
}
/**
 * Answer true if the receiver's testClass does not
 * yet exist
 *
 * @return boolean
 */
public boolean isNewTest() {
	String clsName = getQualifiedClassName();
	if (clsName.length() == 0)
		return true;
	try {
		Class cls = Class.forName(clsName);
		return false;
	} catch (Throwable e) {
		return true;
	}
}
/**
 * Answer the current author of the receiver's test
 *
 * @return String
 */
void removeListener(IUlxTestListener listener) {
	int index = -1;
	for (int i = 0; i < fListeners.length; i++) {
		if (fListeners[i] == listener) {
			index = i;
			break;
		}
	}
	if (index > -1) {
		int newLength = fListeners.length - 1;
		if (newLength > 0) {
			IUlxTestListener[] newList = new IUlxTestListener[newLength];
			if (index > 0)
				System.arraycopy(fListeners, 0, newList, 0, index);
			if (index < fListeners.length)
				System.arraycopy(fListeners, index + 1, newList, index, (newList.length - index));
			fListeners = newList;
		} else {
			fListeners = new IUlxTestListener[0];
		}
	}
}
/**
 * Perform the run method.
 */
public void run() {
	fSystem.run(this);
}
/**
 * set the current author of the receiver's test
 *
 * @param String
 */
void setAuthor(String string) {
	fAuthor = string;
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
 void setComponent(Class cls) {
	Object[] noParms = new Object[0];
	String clsName = cls.getName();
	fTestClassName = clsName.substring(clsName.lastIndexOf(".") + 1);
	fPackageName = clsName.substring(0, clsName.lastIndexOf("."));
	fDescription = (String) UlxMessage.invoke(cls, "testDescription", fDescription);
	fTestedClasses = (String[]) UlxMessage.invoke(cls, "testedClasses", noParms, fTestedClasses); 
	fTestedAPI = (String[]) UlxMessage.invoke(cls, "testedAPI", noParms, fTestedAPI);
	fTestCategories = (String[]) UlxMessage.invoke(cls, "testCategories", noParms, fTestCategories);
	fTestedPRs = (String[]) UlxMessage.invoke(cls, "testedPRs", noParms, fTestedPRs);
	fAuthor = (String) UlxMessage.invoke(cls, "testAuthor", fAuthor);
	fTabString = (String) UlxMessage.invoke(cls, "testPageTabString", fTabString);
}
/**
 * Answer the current author of the receiver's test
 *
 * @return String
 */
void setDataDone(IUlxTestListener listener, String[] attributeNames) {
	fState = STATE_DIRTY;
	updateListeners(attributeNames, listener);
}
/**
 * Set the current description of the receiver's test.
 *
 * @param String
 */
void setDescription(String string) {
	fDescription = string;
}
/**
 * set the current author of the receiver's test
 *
 * @param String
 */
void setIdentifier(int identifier) {
	fid = identifier;
}
/**
 * Set the list of test categories covered by the receiver's test to @strings.
 *
 * @param String[]
 */
void setTestCategories(String[] strings) {
	fTestCategories = strings;
}
/**
 * set the component class of the receiver
 *
 * @param Class the class
 */
public void setTestClass(Class cls) {
	setComponent(cls);
}
/**
 * set the class name of the receiver's test
 *
 * @param String the class name without path information
 */
void setTestClassName(String string) {
	fTestClassName = string;
}
/**
 * Set the list of methods tested by the receiver's test to @strings.
 *
 * @param String[]
 */
void setTestedAPI(String[] strings) {
	fTestedAPI=strings;
}
/**
 * Set the list of class names tested by the receiver's test to @strings.
 *
 * @param String[]
 */
void setTestedClasses(String[] strings) {
	fTestedClasses = strings;
}
/**
 * Set the list of PRs verified by the receiver's test to @strings.
 *
 * @param String[]
 */
void setTestedPRs(String[] strings) {
	fTestedPRs = strings;
}
/**
 * set the class name of the receiver's test
 *
 * @param String the path name without class name
 */
void setTestPackageName(String string) {
	fPackageName = string;
}
/**
 * set the String displayed on the reciever's page to @string
 *
 * @param String
 */
void setTestPageTabString(String string) {
	fTabString = string;
}
/**
 * Override this method to return the requested value for the given key.
 *
 * @param formAttributeName 	The key at which the object is.
 */
public void setValueAt(Object object, String formAttributeName) {
	if (formAttributeName.equals("listString")) {
		return;
	}
	if (formAttributeName.equals("testClassName")) {
		setTestClassName((String) object);
		return;
	}
	if (formAttributeName.equals("testPackageName")) {
		setTestPackageName((String) object);
		return;
	}
	if (formAttributeName.equals("description")) {
		setDescription((String) object);
		return;
	}
	if (formAttributeName.equals("author")) {
		setAuthor((String) object);
		return;
	}
	if (formAttributeName.equals("tabString")) {
		setTestPageTabString((String) object);
		return;
	}
	return;
}
/**
 * Answer true, if the receiver's test class can be run
 */
String toString(String[] strings, String separator) {
	String answer;
	if (strings.length == 0)
		answer = "N/A";
	else
		answer = "";
	boolean started = false;
	for (int i = 0; i < strings.length; i++) {
		if (!started) {
			started = true;
			answer = strings[i];
		}
		else
			answer = answer + separator + strings[i];
	}
	return answer;
}
/**
 * The receier has been updated, with @success indicating the success of that operation.
 *
 * @param boolean	if the receiver's source has been updated successfully, this is true.
 */
void updated(boolean success) {
	if (success)
		fState = STATE_CLEAN;
	else
		fState = STATE_DIRTY;
}
/**
 * Answer the current author of the receiver's test
 *
 * @return String
 */
void updateListeners(String[] attributeNames, IUlxTestListener listener) {
	for (int i = 0; i < fListeners.length; i++) {
		if (fListeners[i] != listener) {
			fListeners[i].testChanged(this, attributeNames);
		}
	}
}
}
