package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import com.ibm.ulc.application.*;
public class UlxTreeModel extends ULCTreeModel implements IUlxModelOwner {
	private IUlxTreeNodeAdapter fNodeAdapter = null;
	private IUlxModel fRoot = null;
/**
 * UlxTreeModel constructor comment.
 */
public UlxTreeModel() {
	super();
}
/**
 * UlxTreeModel constructor comment.
 * @param prefetchCount int
 */
public UlxTreeModel(IUlxTreeNodeAdapter adapter) {
	this();
	fNodeAdapter = adapter;
}
/**
 * Override this method to return the number of children
 * for the given userObject (parent).
 *
 * @param userObject	The domain object whose childCount is required.
 */
public int getChildCount(Object userObject) {
	IUlxModel model = (IUlxModel) userObject;
	return getNodeAdapter().getChildCount(model);
}
/**
 * Override this method to return the number of children
 * for the given userObject (parent).
 *
 * @param userObject	The domain object whose childCount is required.
 */
public java.util.Vector getChildren(Object userObject) {
	return getNodeAdapter().getChildren((IUlxModel) userObject);
}
/**
 * Override this method to return the number of children
 * for the given userObject (parent).
 *
 * @param userObject	The domain object whose childCount is required.
 */
public ULCIcon getIcon(Object userObject) {
	IUlxModel model = (IUlxModel) userObject;
	return getNodeAdapter().getIcon(model);
}
/**
 * Override this method to return the number of children
 * for the given userObject (parent).
 *
 * @param userObject	The domain object whose childCount is required.
 */
public String getLabel(Object userObject) {
	IUlxModel model = (IUlxModel) userObject;
	return getNodeAdapter().getLabel(model);
}
IUlxTreeNodeAdapter getNodeAdapter() {
	com.ibm.ulc.util.Assert.isNotNull(fNodeAdapter);
	return fNodeAdapter;
}
/**
 * Answer the parent of node. Answer null if that node is the root.
 *
 * @param node The domain object whose parent is required.
 */
public Object getParent(Object child) {
	return getRoot();
}
/**
 * Override this method to return the root object of the tree
 */
public Object getRoot() {
	return fRoot;
}
/**
 * Override this method to return the root object of the tree
 */
public IUlxModel getRootModel() {
	return (IUlxModel) getRoot();
}
/**
 * Override this method to return the root object of the tree
 */
public IUlxModel[] getRows() {
	return getNodeAdapter().withAllChildren(getRootModel());
}
/**
 * Override this method to return the requested value for the 
 * specified cell.
 * This method needs to be overridden by subclasses if they
 * have added columns to the receiver's tree.
 *
 * @param colId	The key of the attribute to be retrieved.
 * @return Object 
 */
public Object getValueAt(String columnId, Object node) {
	return ((IUlxModel) node).getValueAt(columnId);
}
/**
 * This method gets called when a bound property is changed.
 * @param evt A PropertyChangeEvent object describing the event source 
 *   	and the property that has changed.
 */

public void modelChanged(IUlxModel model, String attributeName) {
	if (model.isMapped(this)) {
		if (getNodeAdapter().isChildrenAttribute(attributeName))
			changed(model, true);
		else
			changed(model, false);
	}
}
/**
 * Internal method to register the new object obtained. Answer the 
 * object registered.
 */
protected IUlxModel register(IUlxModel model) {
	model.setIdentifier(this, getIdFor(model));
	return model;
}
/**
 * Internal method to register the new object obtained. Answer the 
 * object registered.
 */
protected Object register(Object model) {
	//Object answer = super.register(model);
	return register((IUlxModel) model);
}
public void setModelIdentifier(IUlxModel model) {
	int index = getIdFor(model);
	if (index > -1)
		model.setIdentifier(this, index);
}
public void setRoot(UlxModel model) {
	fRoot = model;
}
}
