package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import com.ibm.ulc.application.*;
import java.util.Vector;
import java.util.Enumeration;
public abstract class UlxWindowAbstract extends com.ibm.ulc.application.ULCShell  {
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private UlxSystem fieldSystem;
/**
 * UlxWindowAbstract constructor comment.
 */
public UlxWindowAbstract() {
	super();
}
/**
 * UlxWindowAbstract constructor comment.
 * @param title java.lang.String
 * @param parent com.ibm.ulc.application.ULCShell
 * @param modal boolean
 */
public UlxWindowAbstract(String title, ULCShell parent, boolean modal, boolean visible) {
	super(title, parent, modal, visible);
	fieldSystem = (UlxSystem) parent.getContext().getProperty("ulxSystem", null);
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * Add a listener to be notified when this shell is closing in the UI.
 *
 * @param listener The <code>IWindowListener</code> object that will be notified.
 */
public void addWindowClosingListener(IWindowCloseVoter listener) {
	enableOptionalEvent("windowClosing");
	setVeto(true); //FIXME: this should be implicit when a windowClosing is requested
	internalAddListener("windowClosing", listener);
}
void basicQuit() {
	getSystem().quit();
}
/**
 * Open an alert displaying @text on the receiver and answer true or false.
 */
public boolean confirm(String text) {
	ULCAlert alert = new ULCAlert(this, "Please Confirm", text, "Yes", "No");
	return (alert.ask()).equals("Yes");
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
ULCPage getActivePage(ULCNotebook notebook) {
	int activePageIndex = notebook.getActiveTab();
	Object answer = null;
	try {
		answer = notebook.getPages().elementAt(activePageIndex);
	} catch (java.lang.ArrayIndexOutOfBoundsException e) {
	}
	if (answer == null)
		return null;
	else
		return (ULCPage) answer;
}
/**
 * Add a listener to be notified when this shell is closing in the UI.
 *
 * @param listener The <code>IWindowListener</code> object that will be notified.
 */
Vector getListenersFor(String eventName) {
	Vector list = new Vector(0);
	if (fListeners != null) {
		Object value = fListeners.get(eventName);
		if (value != null)
			list = (Vector) value;
	}
	return list;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * Gets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @return The system property value.
 * @see #setSystem
 */
public UlxSystem getSystem() {
	return fieldSystem;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * Received events are converted to <code>ULCWindowEvents</code> and distributed to all
 * registered listeners.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(com.ibm.ulc.comm.ORBConnection conn, String request, com.ibm.ulc.util.Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		if ((type.equals("windowClosing") && (getListenersFor("windowClosing").size() > 0))) {
			(new UlxBallot()).handleWindowClosingEvent(this, getListenersFor("windowClosing"));
			return;
		}
	}
	super.handleRequest(conn, request, args);
}
/**
 * terminate the receiver's ULCApplication
 */
public void quit() {
	if ((getApplication() != null) && requestToQuit())
		basicQuit();
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * answer true if the receiver may quit the application.
 */
abstract public boolean requestToQuit();
/**
 * Sets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @param system The new value for the property.
 * @see #getSystem
 */
public void setSystem(UlxSystem system) {
	UlxSystem oldValue = fieldSystem;
	fieldSystem = system;
	firePropertyChange("system", oldValue, system);
}
/**
 * Gets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @return The system property value.
 * @see #setSystem
 */
void ulxInitialize(ULCVajContext vaContext) {
	if (fieldSystem == null) {
		try {
			UlxContext context = (UlxContext) vaContext;
			setSystem(context.getSystem());
		}
		catch (Throwable t) {
			Object object = vaContext.getProperty("ulxSystem", null);
			UlxSystem system = null;
			if (object == null) {
				system = new UlxSystem();
				vaContext.setProperty("ulxSystem", system);
			}
			else {
				system = (UlxSystem) object;
			}
			setSystem(system);
		}
	}
}
}
