package com.ibm.ulc.test.cases;

import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import java.util.*;
import java.io.*;
/**
 * Test case for methods which get UI properties
 * @author: Daniel Megert (OTI)
 * @since:	R3.1
 */
public class UlxTestProgramStarter extends com.ibm.ulc.test.UlxAbstractTestComposite implements IProgramStarterErrorListener {
	private ULCBox ivjBox1 = null;
	private ULCBox ivjBox2 = null;
	private ULCBorder ivjControlsBorder = null;
	private ULCSplitPane ivjInnerSplitPane = null;
	private ULCBorder ivjInstructionsBorder = null;
	private ULCField ivjinstructionText = null;
	private ULCSplitPane ivjMainSplitPane = null;
	private ULCBorder ivjTestBorder = null;
	private ULCField ivjTextArea = null;
	private ULCButton ivjExecNotepadButton = null;
	private ULCButton ivjNotepadButton = null;
	private ULCButton ivjStartFileButton = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private ULCButton ivjExecButton = null;
	private ULCField ivjExecInputField = null;
	private ULCButton ivjStartCGIButton = null;
	private ULCField ivjStartInputField = null;
	private ULCButton ivjStartPHPButton = null;
	private ULCButton ivjStartServletButton = null;
	private ULCProgramStarter fProgramStarter= null; //new ULCProgramStarter(this.getContext());
	private ULCCheckbox ivjOptionalEventCheckBox = null;
	private ULCButton ivjStartAspButton1 = null;

class IvjEventHandler implements com.ibm.ulc.application.IActionListener, com.ibm.ulc.application.IValueChangedListener {
		public void actionPerformed(com.ibm.ulc.application.ULCActionEvent actionEvent) {
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getStartFileButton()) 
				connEtoC1(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getNotepadButton()) 
				connEtoC2(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getExecNotepadButton()) 
				connEtoC3(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getStartPHPButton()) 
				connEtoC4(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getStartServletButton()) 
				connEtoC5(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getStartCGIButton()) 
				connEtoC6(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getStartAspButton1()) 
				connEtoC7(actionEvent);
			if (actionEvent.getSource() == UlxTestProgramStarter.this.getExecButton()) 
				connEtoC9(actionEvent);
		};
		public void valueChanged(com.ibm.ulc.application.ULCValueChangedEvent e) {
			if (e.getSource() == UlxTestProgramStarter.this.getOptionalEventCheckBox()) 
				connEtoC8(e);
		};
	};
/**
 * UlxTestUIProperties constructor comment.
 */
public UlxTestProgramStarter() {
	super();
	initialize();
}
/**
 * UlxTestUIProperties constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public UlxTestProgramStarter(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
	fProgramStarter= new ULCProgramStarter(getContext());
}
/**
 * connEtoC1:  (StartFileButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.startFile()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.startFile();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (NotepadButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.startNotepad()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.startNotepad();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC3:  (ExecNotepadButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.execNotepad()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.execNotepad();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC4:  (StartPHPButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.openPHP()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC4(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.openPHP();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC5:  (StartServletButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.openServlet()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC5(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.openServlet();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC6:  (StartCGIButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.openCGI()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC6(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.openCGI();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC7:  (StartAspButton1.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.openASP()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC7(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.openASP();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC8:  (OptionalEventCheckBox.valueChanged.valueChanged(com.ibm.ulc.application.ULCValueChangedEvent) --> UlxTestProgramStarter.toggleOptionalEvent()V)
 * @param arg1 com.ibm.ulc.application.ULCValueChangedEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC8(com.ibm.ulc.application.ULCValueChangedEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.toggleOptionalEvent();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC9:  (ExecButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxTestProgramStarter.exec()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC9(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.exec();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
private void exec() {
	getTextArea().setText("");
	fProgramStarter.exec(getExecInputField().getText(), null);
}
private void execNotepad() {
	getTextArea().setText("");	
	fProgramStarter.exec("notepad.exe", null);
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(1, 1);
			ivjBox1.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the Box2 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox2() {
	if (ivjBox2 == null) {
		try {
			ivjBox2 = new com.ibm.ulc.application.ULCBox(6, 2);
			ivjBox2.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getStartFileButton());
			ivjBox2.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 1, getExecButton());
			ivjBox2.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getStartInputField());
			ivjBox2.add(0, 2, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 1, getNotepadButton());
			ivjBox2.add(0, 3, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 1, getStartPHPButton());
			ivjBox2.add(0, 4, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 1, getStartCGIButton());
			ivjBox2.add(0, 5, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getOptionalEventCheckBox());
			ivjBox2.add(1, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getExecInputField());
			ivjBox2.add(1, 4, getStartAspButton1());
			ivjBox2.add(1, 2, getExecNotepadButton());
			ivjBox2.add(1, 3, getStartServletButton());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox2;
}
/**
 * Return the ControlsBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getControlsBorder() {
	if (ivjControlsBorder == null) {
		try {
			ivjControlsBorder = new com.ibm.ulc.application.ULCBorder("Controls");
			ivjControlsBorder.add(getBox2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjControlsBorder;
}
private String getCurrentLAF() {
	return getContext().getLook();
}
/**
 * Return the ExecButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getExecButton() {
	if (ivjExecButton == null) {
		try {
			ivjExecButton = new com.ibm.ulc.application.ULCButton("Execute");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExecButton;
}
/**
 * Return the ExecInputField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getExecInputField() {
	if (ivjExecInputField == null) {
		try {
			ivjExecInputField = new com.ibm.ulc.application.ULCField();
			// user code begin {1}
			if (ivjExecInputField.getValue() == null)
				ivjExecInputField.setText("");
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExecInputField;
}
/**
 * Return the GetAllSystemProperties property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getExecNotepadButton() {
	if (ivjExecNotepadButton == null) {
		try {
			ivjExecNotepadButton = new com.ibm.ulc.application.ULCButton("Exec notepad");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExecNotepadButton;
}
/**
 * Return the InnerSplitPane property value.
 * @return com.ibm.ulc.application.ULCSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCSplitPane getInnerSplitPane() {
	if (ivjInnerSplitPane == null) {
		try {
			ivjInnerSplitPane = new com.ibm.ulc.application.ULCSplitPane(true, getControlsBorder(), getInstructionsBorder());
			ivjInnerSplitPane.setDividerLocation((double) 0.7);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjInnerSplitPane;
}
protected String getInstruction() {
	return "Click the buttons and\nverify that the programs start";
}
/**
 * Return the InstructionsBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getInstructionsBorder() {
	if (ivjInstructionsBorder == null) {
		try {
			ivjInstructionsBorder = new com.ibm.ulc.application.ULCBorder("Instructions");
			ivjInstructionsBorder.add(getinstructionText());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjInstructionsBorder;
}
/**
 * Return the instructionText property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getinstructionText() {
	if (ivjinstructionText == null) {
		try {
			ivjinstructionText = new com.ibm.ulc.application.ULCField(5, 30);
			ivjinstructionText.setLineWrap(true);
			ivjinstructionText.setEditable(false);
			ivjinstructionText.setWordWrap(true);
			// user code begin {1}
			ivjinstructionText.setValue(getInstruction());			
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjinstructionText;
}
private String getLAFs() {
	Enumeration looks= getContext().getInstalledLookAndFeels().elements();
	StringWriter answer= new StringWriter();
	for (; looks.hasMoreElements();) {
		Look look= (Look) looks.nextElement();
		answer.write(look.getName());
		answer.write(": ");
		answer.write(look.getClassName());
		answer.write('\n');
	}
	return answer.toString();
}
private String getLocale() {
	return getContext().getUILocale().toString();
}
/**
 * Return the MainSplitPane property value.
 * @return com.ibm.ulc.application.ULCSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCSplitPane getMainSplitPane() {
	if (ivjMainSplitPane == null) {
		try {
			ivjMainSplitPane = new com.ibm.ulc.application.ULCSplitPane(false, getTestBorder(), getInnerSplitPane());
			ivjMainSplitPane.setDividerLocation((double) 0.5);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMainSplitPane;
}
/**
 * Return the SetTextButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getNotepadButton() {
	if (ivjNotepadButton == null) {
		try {
			ivjNotepadButton = new com.ibm.ulc.application.ULCButton("Start notepad");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNotepadButton;
}
/**
 * Return the OptionalEventCheckBox property value.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCCheckbox getOptionalEventCheckBox() {
	if (ivjOptionalEventCheckBox == null) {
		try {
			ivjOptionalEventCheckBox = new com.ibm.ulc.application.ULCCheckbox();
			ivjOptionalEventCheckBox.setLabel("Receive Errors");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjOptionalEventCheckBox;
}
private String getScreenProperties() {
	StringWriter answer= new StringWriter();
	answer.write("resolution: " + getContext().getUIScreenResolution());
	answer.write('\n');	
	answer.write("height: " + getContext().getUIScreenHeight());
	answer.write('\n');	
	answer.write("width: " + getContext().getUIScreenWidth());
	return answer.toString();
}
/**
 * Return the StartAspButton1 property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getStartAspButton1() {
	if (ivjStartAspButton1 == null) {
		try {
			ivjStartAspButton1 = new com.ibm.ulc.application.ULCButton("Open ASP page");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartAspButton1;
}
/**
 * Return the GetLocal property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getStartCGIButton() {
	if (ivjStartCGIButton == null) {
		try {
			ivjStartCGIButton = new com.ibm.ulc.application.ULCButton("Open CGI page");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartCGIButton;
}
/**
 * Return the StartFileButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getStartFileButton() {
	if (ivjStartFileButton == null) {
		try {
			ivjStartFileButton = new com.ibm.ulc.application.ULCButton("Start file");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartFileButton;
}
/**
 * Return the InputField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getStartInputField() {
	if (ivjStartInputField == null) {
		try {
			ivjStartInputField = new com.ibm.ulc.application.ULCField();
			// user code begin {1}
			if (ivjStartInputField.getValue() == null)
				ivjStartInputField.setText("");
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartInputField;
}
/**
 * Return the SetGreenIconButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getStartPHPButton() {
	if (ivjStartPHPButton == null) {
		try {
			ivjStartPHPButton = new com.ibm.ulc.application.ULCButton("Open PHP page");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartPHPButton;
}
/**
 * Return the SetNoIconButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getStartServletButton() {
	if (ivjStartServletButton == null) {
		try {
			ivjStartServletButton = new com.ibm.ulc.application.ULCButton("Open Servlet page");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStartServletButton;
}
/**
 * Return the TestBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getTestBorder() {
	if (ivjTestBorder == null) {
		try {
			ivjTestBorder = new com.ibm.ulc.application.ULCBorder("Test Area");
			ivjTestBorder.add(getBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTestBorder;
}
/**
 * Return the TextArea property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getTextArea() {
	if (ivjTextArea == null) {
		try {
			ivjTextArea = new com.ibm.ulc.application.ULCField(5, 10);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTextArea;
}
private java.lang.String getUISystemProperties() {
	Vector v= new Vector(System.getProperties().keySet());
	Properties props= getContext().getUISystemProperties(v);
	if (props == null)
		return "SecurityException occured";
	return props.toString();
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getStartFileButton().addActionListener(ivjEventHandler);
	getNotepadButton().addActionListener(ivjEventHandler);
	getExecNotepadButton().addActionListener(ivjEventHandler);
	getStartPHPButton().addActionListener(ivjEventHandler);
	getStartServletButton().addActionListener(ivjEventHandler);
	getStartCGIButton().addActionListener(ivjEventHandler);
	getStartAspButton1().addActionListener(ivjEventHandler);
	getOptionalEventCheckBox().addValueChangedListener(ivjEventHandler);
	getExecButton().addActionListener(ivjEventHandler);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getMainSplitPane());
		initConnections();
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	// user code end
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		com.ibm.ulc.application.ULCVajContext.testULCClass(args, UlxTestProgramStarter.class);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of com.ibm.ulc.test.UlxAbstractTestComposite");
		exception.printStackTrace(System.out);
	}
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new UlxTestProgramStarter(context);
}
private void openASP() {
	fProgramStarter.start("http://search.microsoft.com/germany/default.asp?so=RECCNT&qu=Hello&boolean=PHRASE&intCat=0&intCat=1&intCat=2&intCat=3&intCat=4&intCat=5&intCat=6&intCat=7&intCat=8&intCat=9&intCat=10&p=1&nq=NEW", null);
}
private void openCGI() {
	fProgramStarter.start("http://ragingsearch.altavista.com/cgi-bin/query?q=ULC&search=Search", null);
}
private void openPHP() {
	fProgramStarter.start("http://www.zueritipp.ch/sommer/bars/bars.php3", null);
}
private void openServlet() {
	getTextArea().setText("");
	fProgramStarter.start("http://www.google.com/search?q=MS-DOS+Escape+character+special&hl=en&safe=off&btnG=Google+Search", null);
}
public void programStarterError(ULCProgramStarterErrorEvent event) {
	getTextArea().setText(
		"Method:  " + event.getMethodString() + "\n" +
		"cmdLine: " + event.getCommandLineString() + "\n" +		
		"Error:   " + event.getErrorString() + "\n");

}
/**
 * Adds, selects and removes some items
 */
public boolean runIt(boolean visibly) {
	boolean result= true;
	testStarted("com.ibm.ulc.test.cases.UlxTestUIProperties");	
	try {
		testMessage("Start notepad");
		startNotepad();
		pause();
		testMessage("Exec notepad");
		execNotepad();
		pause();
		testMessage("Start file");
		startFile();
		pause();
		testCompleted(result);
		return result;
	}
	catch (Throwable e) {
		e.printStackTrace();
		testCompleted(false);
		return false;
	}
}
private void startFile() {
	fProgramStarter.start(getStartInputField().getText(), null);
}
private void startNotepad() {
	fProgramStarter.start("notepad", null);
}
public static java.lang.String testAuthor() {
	return "OTI";
}
public static java.lang.String[] testCategories() {
	return new String[] {};
}
public static String testDescription() {
	return "Test the ULCProgramStarter";
}
public static java.lang.String[] testedAPI() {
	return new String[] {"exec", "start"};
}
/**
 * Answer the names of the ULC classes tested in this component.
 *
 * Unless the classse tested are defined in <code>com.ibm.ulc.application</code>, the
 * class names must be fully specified. This information is optional if @testedPRs 
 * is specified.
 */
static public String[] testedClasses() {
	return new String[] {"ProgramStarter"};
}
/**
 * Answer the names of the PR verified by this component.
 *
 * The answer contains the name(s) of the PR which the receiver verfies. This
 * information is optional if @testedClasses and/or testedAPI is specified.
 */
static public String[] testedPRs() {
	return new String[] {"1FSMK3S"};
}
public static java.lang.String testPageTabString() {
	return "ProgramStarter tests";
}
private void toggleOptionalEvent() {
	if (getOptionalEventCheckBox().isSelected())
		fProgramStarter.addProgramStarterErrorListener(this);
	else
		fProgramStarter.removeProgramStarterErrorListener(this);	
}
}
