package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.util.Enumeration;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;


public class UIButtonGroup extends UIProxy {
	protected ButtonGroup fButtonGroup= null;
public UIButtonGroup() {
	fButtonGroup = new ButtonGroup();
}
public void add(UIComponent uic) {
	if (uic != null) {
		Component comp = uic.getComponent();
		if (comp != null && comp instanceof AbstractButton)
			fButtonGroup.add((AbstractButton) comp);
	}
}
public void free() {
	removeAll();
	fButtonGroup = null;
	super.free();
}
public void remove(UIComponent uic) {
	if (uic != null) {
		Component comp = uic.getComponent();
		if (comp != null && comp instanceof AbstractButton)
			fButtonGroup.remove((AbstractButton) comp);
	}
}
public void removeAll() {
	if (fButtonGroup != null) {
		Enumeration e = fButtonGroup.getElements();
		while (e.hasMoreElements()) {
			fButtonGroup.remove((AbstractButton) e.nextElement());
		}
	}
}
}
