package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

public class UICachedIcon extends UIIcon implements ICachedResource {
	protected String fCacheKey = null;
	protected String fHostName = null;
	protected String fAppName = null;
	protected String fPathString = null;
	protected String fTimestamp = null;
	protected int fFileSize = -1;
	protected boolean fCached = false;
	protected byte[] fBytes = null;
	private static byte[] fDefaultBytes = {71, 73, 70, 56, 57, 97, 15, 0, 16, 0, -77, 0, 0, -1, -1, -1, -128, 0, 0, 0, -128, 0, -128, -128, 0, 0, 0, -128, -128, 0, -128, 0, -128, -128, -128, -128, -128, -64, -64, -64, -1, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1, 0, -1, -1, 102, 102, 0, 33, -7, 4, 9, 8, 0, 8, 0, 44, 0, 0, 0, 0, 15, 0, 16, 0, 0, 4, 48, 16, -55, 73, -21, 84, 56, 99, -117, 20, -8, -32, 86, 121, -32, -25, 41, 99, 105, 102, 20, -87, -102, -19, 27, -58, 50, -128, 94, -75, 77, -53, -73, -28, -66, -67, 78, 46, -8, 83, 17, 53, -56, 32, 103, -55, -100, 68, 0, 0, 59}; 
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
protected void basicRestoreState(ORBConnection conn, Anything args) {
	fCached = args.isDefined("icon");
	if (fCached) {
		super.basicRestoreState(conn, args);
	}
	else {
		Anything cacheInfo = args.get("ci");
		fFileSize = (int) cacheInfo.get("fsz", -1);
		fTimestamp = (String) cacheInfo.get("fts", null);
		fHostName = (String) cacheInfo.get("hn", null);
		fAppName = (String) cacheInfo.get("an", null);
		fPathString = (String) cacheInfo.get("ps", null);
		cachedResources().add((ICachedResource) this);
	}
}
protected void extractImage(Anything args) {
	super.extractImage(args);
	cachedResources().setResource(this);
}
public String getApplicationName() {
	return fAppName;
}
public String getCacheKey() {
	return fCacheKey;
}
public int getFileSize() {
	return fFileSize;
}
public String getHostName() {
	return fHostName;
}
public Image getImage() {
	return fImage;
}
public Image getImage(Object component, String methodName, Object userData) {
	Image answer = fImage;
	if (answer == null) {
		cachedResources().addUpdate(this, newUpdate(component, methodName, userData));
		/*answer = Toolkit.getDefaultToolkit().createImage(fDefaultBytes);*/
	}
	return answer;
}
public String getPathString() {
	return fPathString;
}
public Object getResource() {
	return getImage();
}
public void getResourceFromUlc() {
	this.sendULC("getCacheData");
}
public String getTimestamp() {
	return fTimestamp;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setCacheData")) {
		this.setCacheData(args);
		return;
	}
	super.handleRequest(conn, request, args);
}
public void readResource(InputStream inStream) {
	try {
		ByteArrayOutputStream outStream = new ByteArrayOutputStream();
		int b = 0;
		while ((b = inStream.read()) != -1)
			outStream.write(b);
		outStream.close();
		byte[] bytes = outStream.toByteArray();
		fBytes = bytes;
		fImage = Toolkit.getDefaultToolkit().createImage(bytes);
	}
	catch (IOException e) {
		trouble("read resource", "io exception encountered");
	}
}
public void setCacheData(Anything anything) {
	fBytes = anything.getBytes("icon");
	extractImage(anything);
	/* set the bytes, they are needed in writeResource */
	cachedResources().setResource(this);
	/* reset the bytes, they are no longer needed */
	/*fBytes = null;*/
}
public void setCacheKey(String aString) {
	fCacheKey = aString;
}
public void setResource(Object image) {
	fImage = (Image) image;
}
public void writeResource(OutputStream stream) {
	if (fBytes != null) {
		try {
			stream.write(fBytes);
		}
		catch (IOException e) {
			trouble("write resource", "io exception encountered");
		}
	}
}
}
