package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;

public class UIFiller extends UIComponent {
	protected JLabel fLabel = new UiJLabel();
	public void free() {
		fLabel= null;
		super.free();
	}
	public Component getComponent() {
		return fLabel;
	}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	Dimension size = new Dimension(args.get("w", 0), args.get("h", 0));
	//fLabel.setSize(size);
	fLabel.setPreferredSize(size);
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	setBackgroundColorWithOpaque(red, green, blue, refresh);
}
}
