package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

public class UIIcon extends UIProxy {
	protected Image fImage = null;
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
protected void basicRestoreState(ORBConnection conn, Anything args) {
	extractImage(args);
}
protected void extractImage(Anything args) {
	byte[] data = args.getBytes("icon");
	if (data != null) {
		fImage = Toolkit.getDefaultToolkit().createImage(data);
		if (fImage == null) {
			trouble("extractImage", "couldn't create image from data");
		}
	}
	else {
		trouble("extractImage", "data missing");
	}
}
	public void free() {
		fImage= null;
		super.free();
	}
	public Image getImage() {
		if (fImage == null)
			trouble("getImage", "fImage == null");
		return fImage;
	}
public Image getImage(Object component, String methodName) {
	return getImage(component, methodName, null);
}
public Image getImage(Object component, String methodName, Object userData) {
	return getImage();
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	basicRestoreState(conn, args);
}
	public static
	void waitForImage(Image image, Component c) {
		if (image != null) {
			try {
				MediaTracker tracker= new MediaTracker(c);
				tracker.addImage(image, 0);
				tracker.waitForID(0);
			} catch (Exception e) {
				trouble2("UIIcon.waitForImage", "got exception");
			}
		}
	}
}
