package com.ibm.ulc.ui;

import java.awt.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.base.*;
/**
 * The instances of this class are used to mark widgets as needing
 * more user input.
 * At the same time they carry a policy for showing this to the user
 * and store the normal widget's attribute.
 */
public abstract class UIMandatoryInputStyle extends UlcObject implements IDefaults {
	protected Color fHighlightColor = null;
	protected UlcHashtable fProperties = new UlcHashtable();

	/** the key to store the component's "needsInput" property
	 */
	protected static final String NEEDS_INPUT = "needsInput"; 

	/** the key to store the compoent's "color" property
	 */
	protected static final String COLOR = "color";

/**
 * Return an instance of a UINeedsMoreInputMark based on the supplied type
 *
 * @param int typeCode
 */
public static UIMandatoryInputStyle forType(int typeCode) {
	if (typeCode == MANDATORY_STYLE_BORDERED)
		return new UIMandatoryInputBorderStyle();
	return new UIMandatoryInputBackgroundColorStyle();
}
/**
 * Get the specified boolean property for the object at the specified key.
 *
 * @return boolean
 */
protected boolean getBooleanPropertyValue(Object anObject, String key) {
	return getBooleanPropertyValue(anObject, key, false);
}
/**
 * Get the specified boolean property for the object at the specified key.
 *
 * @return boolean
 */
protected boolean getBooleanPropertyValue(Object anObject, String key, boolean defaultValue) {
	Boolean b = new Boolean(defaultValue);

	Object o = getPropertyValue(anObject, key);
	if (o != null)
		b = (Boolean) o;
	return b.booleanValue();
}
/**
 * Get the background color that is used to indicate that the widget needs more input.
 *
 * @return Color
 */
protected Color getHighLightColor() {
	if (fHighlightColor == null) {
		fHighlightColor = Color.yellow;
	}
	return fHighlightColor;
}
/**
 * Get the specified property for the object at the specified key.
 *
 * @return Object
 */
protected Object getPropertyValue(Object aObject, String key) {
	Object o = fProperties.get(aObject);
	if (o == null)
		return null;
	UlcHashtable ht = (UlcHashtable) o;
	return ht.get(key);
}
/**
 * Get the specified property for the object at the specified key.
 *
 * @return Object
 */
protected Object getPropertyValue(Object aObject, String key, Object defaultValue) {
	Object o = fProperties.get(aObject);
	if (o == null)
		return defaultValue;
	UlcHashtable ht = (UlcHashtable) o;
	if (ht.containsKey(key))
		return ht.get(key);
	else
		return defaultValue;
}
/**
 * Perform any processing necessary for the initialization of the component
 *
 */
abstract protected void initializeForComponent(UIComponent component);
/**
 * Configure the UIComponent to show that more input is needed.
 *
 * @param boolean 		needsMoreInput	If true the component needs input.
 * @param UIComponent	component		The INeedsMoreInput UIComponent
 */
abstract public void mark(boolean needsMoreInput, UIComponent component);

/**
 * Set the attributes used to display the mandatory character again,
 * in order to trigger a refresh of the user interface.
 */
abstract void refreshNeedsMoreInputAttributes(boolean needsMoreInput, UIComponent c);
	
/**
 * Set the specified boolean property for the object at the specified key to the specified value.
 *
 */
protected void setBooleanPropertyValue(Object aObject, String key, boolean value) {
	Object o = fProperties.get(aObject);
	if (o == null)
		fProperties.put(aObject, o = new UlcHashtable());
	UlcHashtable ht = (UlcHashtable) o;
	ht.put(key, new Boolean(value));
}
/**
 * Set the background color that is used to indicate that the widget needs more input.
 *
 */
protected void setHighLightColor(Color color) {
	fHighlightColor = color;
}
/**
 * Set the specified property for the object at the specified key to the specified value.
 *
 */
protected void setPropertyValue(Object aObject, String key, Object value) {
	Object o = fProperties.get(aObject);
	if (o == null)
		fProperties.put(aObject, o = new UlcHashtable());
	UlcHashtable ht = (UlcHashtable) o;
	ht.put(key, value);
}
}
