package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;
public class UISeparator extends UIComponent implements IMenuComponent {
	protected Component fSeparator = null;
	public boolean fVisible = true;
/**
 * The receiver is expected to configure itself to be an item in either a menubar
 * (if @isMenuBarItem is true), or a popup menu (if @isMenuBarItem is false)
 */
public void configureAsMenuBarItem(boolean isMenuBarMenu) {
}
public void free() {
	fSeparator = null;
	super.free();
}
public Component getComponent() {
	return fSeparator;
}
/**
 * The receiver is expected to insert itself in both the UIMenu and its associated JMenu.
 * if <code>isMenuBarItem</code> is true, the receiver is expected to configure itself properly as
 * such. <code>index</code> indicates at which offset into <code>jmenu</code> the receiver is to be inserted.
 *
 * @param menu		the UIMenu into which the receiver is to be inserted
 * @param jmenu		the physical JMenu into which the receiver's compoennt is to be inserted
 * @param isMenuBarItem indicates whether <code>menu</code> is a menubar menu
 * @param index		the index at which the receiver is to be inserted into <code>menu</menu>
 *
 */
public void insertIn(UIMenu menu, JMenu jmenu, boolean isMenuBarMenu, int index) {
	jmenu.insertSeparator(index);
	setComponent(jmenu.getPopupMenu().getComponents()[index]);
}
/*
 * The receiver prepares its <code>JComponent</code> for display
 *
 */
public void prepareForPopup() {
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/99 11:28:57 AM)
 * @param menu javax.swing.JMenu
 */
public void rebuildPopupMenu(JMenu menu) {
	if (fVisible)
		menu.add(getComponent());
}
/**
 * The receiver is expected to remove itself from @jmenu (the associated menu of @menu).
 * @index indicates at which offset into @jmenu the receiver currently is.
 */
public void removeFrom(UIMenu menu, JMenu jmenu, int index) {
	((JPopupMenu) jmenu.getPopupMenu()).remove((JSeparator) getComponent());
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	setComponent(new JSeparator() {
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		};
	});
	super.restoreState(conn, args);
}
/**
 * We implement this method since the UIToolbar needs to call this method to store
 * the actual widget added to the JToolbar
 */
public void setComponent(Component component) {
	fSeparator = component;
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	if (fVisible != visible) {
		fVisible = visible;
		if (getProxyParent() != null)
			try {
			((UIMenu) getProxyParent()).setVisible(this, visible);
		}
		catch (ClassCastException c) {
			super.setVisible(visible);
		}
	}
}
}
