package com.ibm.ulc.ui;

import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.*;
import javax.swing.*;
import java.awt.*;

public class UISplitPane extends UIComponent {
	protected JSplitPane fSplitPane= null;
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(UIComponent component) {
	internalAddToChildren(component);
}
	public Component getComponent() {
	    return fSplitPane;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setVertical")) {
		setVertical(args.asBoolean(false));
		return;
	}
	if (request.equals("setDividerLocation")) {
		double dividerLocation = args.asDouble(-1);
		if (dividerLocation != -1)
			setDividerLocation(dividerLocation);
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	boolean vertical = args.get("v", false);
	UIComponent leftComponent = (UIComponent) getManaged(UIProxy.class, conn, args.get("l"));
	UIComponent rightComponent = (UIComponent) getManaged(UIProxy.class, conn, args.get("r"));
	int orientation = (vertical ? JSplitPane.VERTICAL_SPLIT : JSplitPane.HORIZONTAL_SPLIT);
	Component lc, rc;
	if (leftComponent == null) {
		lc = new UiJLabel("undefined leftComponent");
	} else {
		lc = leftComponent.getComponent();
		add(leftComponent);
	}
	if (rightComponent == null)
		rc = new UiJLabel("undefined leftComponent");
	else {
		rc = rightComponent.getComponent();
		add(rightComponent);
	}
	((JComponent) lc).setMinimumSize(new Dimension(1, 1));
	((JComponent) rc).setMinimumSize(new Dimension(1, 1));
	fSplitPane = new UiJSplitPane(orientation, false, lc, rc);
	final double dividerLocation = args.get("dl", -1.0);
	super.restoreState(conn, args);
	if (dividerLocation != -1) {
		DeferredRequest r = new DeferredRequest(conn) {
			public void safeDispatch() {
				// Bug Parade Id:4148530,frame needs to be packed first
				setDividerLocation(dividerLocation);
			}
		};
		conn.postRequest(r);
	}
}
/**
 * Sets the divider location as a percentage of the JSplitPane's size.
 *
 * @param proportionalLocation  a double-precision floating point value that
 *        specifies a percentage, from zero (top/left) to 1.0 (bottom/right)
 */
public void setDividerLocation(double proportionalLocation) {
	if ((proportionalLocation >= 0.0) && 
		(proportionalLocation <= 1.0) && 
		(fSplitPane != null)) {
		fSplitPane.setDividerLocation(proportionalLocation);
	}
}
void setVertical(boolean vertical) {
	fSplitPane.setOrientation(vertical ? JSplitPane.VERTICAL_SPLIT : JSplitPane.HORIZONTAL_SPLIT);
}
}
