package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.Assert;
import java.util.*;
public abstract class UIToggleButton extends UIFormComponent implements ItemListener, IEnableListener {
	protected JToggleButton fToggle = null;
	protected boolean fIsCheckbox;
	protected String fValue = null;
	protected Vector fEmptyStateListeners = null;
	protected UITrigger fTrigger = null;
protected UIToggleButton(boolean checkBox) {
	fIsCheckbox = checkBox;
}
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void addEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (fEmptyStateListeners == null)
		fEmptyStateListeners = new Vector();
	fEmptyStateListeners.addElement(component);
	component.setEnabled(shouldEnableListener());
}
void enableListeners() {
	if (fEmptyStateListeners != null) {
		boolean state = false;
		if (fToggle != null)
			state = fToggle.isSelected();
		Enumeration e = fEmptyStateListeners.elements();
		while (e.hasMoreElements()) {
			IEnableListenerTarget c = (IEnableListenerTarget) e.nextElement();
			c.setEnabled(state);
		}
	}
}
public void free() {
	if (fToggle != null) {
		if (fToggle instanceof UiJCheckbox) {
			UiJCheckbox t = (UiJCheckbox) fToggle;
			t.free();
		}
		fToggle.removeItemListener(this);
		fToggle = null;
	}
	fValue = null;
	super.free();
}
public Component getComponent() {
	return fToggle;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setSelected")) {
		setState(args.asBoolean(false));
		return;
	}
	if (request.equals("setMnemonic")) {
		setMnemonic(args.asInt(-1));
		return;
	}
	if (request.equals("setTrigger")) {
		if (args.isNull())
			fTrigger = null;
		else
			fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args);
		return;
	}
	super.handleRequest(conn, request, args);
}
public void itemStateChanged(ItemEvent e) {
	boolean state = e.getStateChange() == ItemEvent.SELECTED;
	if (fFormModel != null) {
		if (fValue != null) {
			if (state) {
				if (fValue.equals("true")) {
					fFormModel.setValueAt(new Boolean(true), fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
				} else
					if (fValue.equals("false")) {
						fFormModel.setValueAt(new Boolean(false), fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
					} else {
						fFormModel.setValueAt(fValue, fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
					}
			}
		} else {
			fFormModel.setValueAt(new Boolean(state), fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
		}
	} else {
		sendEventULC("itemStateChange", "selected", new Anything(state));
	}
	enableListeners();
	if (fTrigger != null)
		fTrigger.trigger(fConnection, TRIGGER_ON_ACTION_AND_SELECTION, this, null);
}
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (fEmptyStateListeners == null)
		return;
	fEmptyStateListeners.removeElement(component);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fValue = args.get("value", null);
	String label = args.get("label", "no name");
	UiLabelAndMnemonic u = internalParseLabelForMnemonic(label);
	label = u.fLabel;
	if (fIsCheckbox)
		fToggle = new UiJCheckbox(label);
	else
		fToggle = new JRadioButton(label) {
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		}
	};
	if (u.fMnemonic != null)
		setMnemonic(u.fMnemonic.charValue());
	if (args.isDefined("mnemonic"))
		setMnemonic(args.get("mnemonic", -1));
	super.restoreState(conn, args);
	UIButtonGroup rg = (UIButtonGroup) getManaged(UIButtonGroup.class, conn, args.get("group"));
	if (rg != null)
		rg.add(this);
	fToggle.addItemListener(this); // add listener before setState (we remove it there)

	if (fFormModel != null)
		updateFromModel();
	else
		setState(args.get("selected", false));
	fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args.get("trigger"));
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	setBackgroundColorWithOpaque(red, green, blue, refresh);
}
public void setLabel(String label) {
	fToggle.setText(label);
}
private void setMnemonic(int keyCode) {
	if (keyCode != -1)
		fToggle.setMnemonic((char)keyCode);
}
void setState(boolean s) {
	if (fToggle.isSelected() != s) {
		fToggle.removeItemListener(this);
		fToggle.setSelected(s);
		fToggle.addItemListener(this);
	}
	enableListeners();
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 */
public boolean shouldEnableListener() {
	if (fToggle != null)
		return fToggle.isSelected();
	else
		return false;
}
public void updateFromModel() {
	if (fFormModel != null) {
		Object o = fFormModel.getValueAt(fKey);
		if (o instanceof PendingCell)
			o = null;
		if (o != null) {
			if (o instanceof Boolean) {
				Boolean b = (Boolean) o;
				boolean val = b.booleanValue();
				if (fValue != null) { // special case
					if (fValue.equals("true"))
						setState(val == true);
					else
						if (fValue.equals("false"))
							setState(val == false);
						else
							; // no change
				} else {
					setState(val);
				}
			} else
				if (fValue != null && o instanceof String) {
					String s = (String) o;
					setState(s.equals(fValue));
				}
			// Commented out to fix PR 1FMP9V1
			// setEnabled(true);
		} else {
			// Commented out to fix PR 1FMP9V1
			// setEnabled(false);
		}
	}
}
}
