package com.ibm.ulc.ui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import java.util.*;
import com.ibm.ulc.util.Assert;
public abstract class UIToggleMenuItem extends UIMenuItem implements ItemListener, IEnableListener {
	protected Vector fEmptyStateListeners = null;
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void addEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (fEmptyStateListeners == null)
		fEmptyStateListeners = new Vector();
	fEmptyStateListeners.addElement(component);
	if (fMenuItem != null)
		component.setEnabled(fMenuItem.isSelected());
	else
		component.setEnabled(false);
}
void enableListeners() {
	if (fEmptyStateListeners != null) {
		boolean state = false;
		if (fMenuItem != null)
			state = fMenuItem.isSelected();
		Enumeration e = fEmptyStateListeners.elements();
		while (e.hasMoreElements()) {
			IEnableListenerTarget c = (IEnableListenerTarget) e.nextElement();
			c.setEnabled(state);
		}
	}
}
	public void free() {
		if (fMenuItem != null) {
			fMenuItem.removeItemListener(this);
		}	
		super.free();
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setSelected")) {
		setState(args.asBoolean(false));
		return;
	}
	super.handleRequest(conn, request, args);
}
public void itemStateChanged(ItemEvent e) {
	sendEventULC("itemStateChange", "selected", new Anything(e.getStateChange() == ItemEvent.SELECTED));
	enableListeners();
	if (fTrigger != null)
		fTrigger.trigger(fConnection, TRIGGER_ON_ACTION_AND_SELECTION, this, null);
}
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (fEmptyStateListeners == null)
		return;
	fEmptyStateListeners.removeElement(component);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	setState(args.get("selected", false));
	UIButtonGroup rg = (UIButtonGroup) getManaged(UIButtonGroup.class, conn, args.get("group"));
	if (rg != null)
		rg.add(this);
	fMenuItem.addItemListener(this);
}
protected void setState(boolean state) {
	if (fMenuItem != null)
		fMenuItem.setSelected(state);
	enableListeners();
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 *
 */
public boolean shouldEnableListener() {
	if (fMenuItem != null)
		return fMenuItem.isSelected();
	else
		return false;
}
}
