package com.ibm.ulc.ui;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.util.Enumeration;
import com.ibm.ulc.util.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.comm.ORBConnection;
public class UIToolBar extends UIComponent {
	protected JToolBar fToolBar = null;
	protected int fMargin = 1;
	protected int fButtonMargin = 1;
	protected boolean fVisible = true;
	protected boolean fEnabled = true;
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param proxy : A <code>UIComponent</code>
 */
public void add(UIComponent proxy) {
	Component c = proxy.getComponent();
	try {
		UiJButton b = (UiJButton) c;
		b.setFocusTraversable(false);
		b.setMargin(new Insets(fButtonMargin, fButtonMargin, fButtonMargin, fButtonMargin));
		fToolBar.add(c);
	} catch (ClassCastException e) {
		try {
			UISeparator s = (UISeparator) proxy;
			fToolBar.addSeparator();
			Component sep = (Component) fToolBar.getComponents()[fToolBar.getComponents().length - 1];
			((UISeparator) proxy).setComponent(sep);
		} catch (ClassCastException ex2) {
			System.out.println("UIToolBar: Illegal widget " + c.toString() + " Only UlcButton or ULCSeparator allowed");
		}
	}
	if (!fVisible)
		c.setVisible(fVisible);
	if (!fEnabled)
		c.setEnabled(fEnabled);
	forceParentResize();
}
protected void forceParentResize() {
	Component parent = getComponent().getParent();
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
		Dimension size = parent.getSize();
		parent.setSize(parent.getSize().width - 1, parent.getSize().height - 1);
		parent.setSize(size);
	}
}
/**
 * getComponent method comment.
 */
public Component getComponent() {
	return fToolBar;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setFloatable")) {
		setFloatable(args.asBoolean(true));
		return;
	}
	if (request.equals("setBorderPainted")) {
		setBorderPainted(args.asBoolean(true));
		return;
	}
	if (request.equals("setMargin")) {
		setMargin(args.asInt(1));
		return;
	}
	if (request.equals("setButtonMargin")) {
		setButtonMargin(args.asInt(1));
		return;
	}
	super.handleRequest(conn, request, args);
}
public void remove(Component c) {
	fToolBar.remove(c);
	Component parent = fToolBar.getParent();
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
		Dimension size= parent.getSize();
		parent.setSize(parent.getSize().width - 1, parent.getSize().height - 1);
		parent.setSize(size);
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fToolBar = new UiJToolBar();
	boolean vertical = args.get("v", false);
	if (vertical)
		fToolBar.setLayout(new BoxLayout(fToolBar, BoxLayout.Y_AXIS));
	if (args.isDefined("floatable"))
		setFloatable(args.get("floatable", true));
	if (args.isDefined("borderPainted"))
		setBorderPainted(args.get("borderPainted", true));
	setMargin(args.get("m", 1));
	setButtonMargin(args.get("bm", 1));
	super.restoreState(conn, args);
}
/**
  * Sets whether the border should be painted.
  *
  * @param b if true, the border is painted.
  * @beaninfo
  * description: Does the toolbar paint its borders?
  *      expert: true
  */
public void setBorderPainted(boolean b) {
	fToolBar.setBorderPainted(b);
	fToolBar.repaint();
}
void setButtonMargin(int buttonMargin) {
	fButtonMargin = buttonMargin;
	Component[] c = fToolBar.getComponents();
	for (int i = 0; i < c.length; i++) {
		try {
			JButton b = (JButton) c[i];
			b.setMargin(new Insets(fButtonMargin, fButtonMargin, fButtonMargin, fButtonMargin));
		} catch (ClassCastException e) {
		}
	}
	fToolBar.invalidate();
	fToolBar.validate();
	fToolBar.repaint();
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	fEnabled= state;
}
/**
  * Sets whether the toolbar can be made to float
  *
  * @param b if true, the toolbar can be dragged out
  * @beaninfo
  * description: Can the toolbar be made to float by the user?
  *       bound: true
  *   preferred: true
  */
public void setFloatable(boolean b) {
	fToolBar.setFloatable(b);
}
void setMargin(int margin) {
	fMargin = margin;
	fToolBar.setMargin(new Insets(margin, margin, margin, margin));
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	super.setVisible(visible);
	fVisible = visible;
}
}
