package com.ibm.ulc.ui;

import com.ibm.ulc.util.UlcObject;
import java.applet.*;
import java.net.*;
import java.awt.Component;
/**
 * This class is used to display a HTML page in an external web browser.
 * If the UI is being run as an Applet it causes the browser in which the
 * applet is running to display the requested page and the browserPath is ignored.
 * If not running as an applet an external web browser is launched.
 * <p>
 * <pre>
 * The rules for determining which external browser is launched is as follows:
 * 	1)	Use the browser path to launch the browser if specified.
 * 	2) 	Under Windows NT/95 and OS2 the system default HTML browser is launched if 
 *		browserPath is not specified.
 *	3) 	On other platforms if the browser path is not specified the default is to
 * 		attempt to get the system property <i>ULC.Browser</i>. If this property is not
 * 		defined then attempt to start the executable Netscape.exe which should be on 
 *		the system path.
 * </pre>
 * <p>
 * NOTE: the browser path if specified must be valid and accessible for the UI-Engine.
 */
public class UiBrowserHelper extends UlcObject {
	protected Applet fApplet = null;
	protected String fBrowserPath = null;
/**
 * (c) Object Technology International.
 */
public UiBrowserHelper(Object applet, String browserPath) {
	fApplet= (Applet) applet;
	fBrowserPath= browserPath;
}
/**
 * Return the URL String patched for specific OS
 *
 * @param   url   an absolute URL giving the location of the document.
 */
protected String getOSSpecificUrlString(URL url) {
	String os= System.getProperty("os.name").toUpperCase();
	String urlString= url.toString();
	if (os.startsWith("WINDOWS"))
		// Quote url for Windows OSs
		urlString= '"' + urlString + '"';
	return urlString;
}
protected void setBrowserPath() {
	String os = System.getProperty("os.name").toUpperCase();
	if (os.startsWith("WINDOWS")) {
		if (os.endsWith("2000") || os.endsWith("NT")) {
			fBrowserPath= "cmd /c start " + '"' + '"';
			return;
		}
		// Other Windows OSs eg 95, 97, 98
		fBrowserPath= "start";
		return;
	}
	if (os.endsWith("OS2")) {
		fBrowserPath= "start";
		return;
	}
	fBrowserPath= System.getProperty("ULC.Browser", "netscape.exe"); //default value for all unknown platforms
}
/**
 * Replaces the Web page currently being viewed with the given URL. 
 * This method may be ignored by applet contexts that are not 
 * browsers. 
 *
 * @param   url   an absolute URL giving the location of the document.
 */
protected void showDocument(URL url) {
	if (fApplet != null) {
		AppletContext appContext = fApplet.getAppletContext();
		if (appContext != null)
			appContext.showDocument(url);
		else
			System.out.println("UIBrowserContext: Error AppletContext was null could not show: " + url.toString());
	}
	else
		showDocumentExternal(url);
}
/**
 * Requests that the browser or applet viewer show the Web page 
 * indicated by the <code>url</code> argument. The 
 * <code>target</code> argument indicates in which HTML frame the 
 * document is to be displayed. 
 * The target argument is interpreted as follows:
 * <p>
 * <center><table border="3"> 
 * <tr><td><code>"_self"</code>  <td>Show in the window and frame that 
 *                                   contain the applet.</tr>
 * <tr><td><code>"_parent"</code><td>Show in the applet's parent frame. If 
 *                                   the applet's frame has no parent frame, 
 *                                   acts the same as "_self".</tr>
 * <tr><td><code>"_top"</code>   <td>Show in the top-level frame of the applet's 
 *                                   window. If the applet's frame is the 
 *                                   top-level frame, acts the same as "_self".</tr>
 * <tr><td><code>"_blank"</code> <td>Show in a new, unnamed
 *                                   top-level window.</tr>
 * <tr><td><i>name</i><td>Show in the frame or window named <i>name</i>. If 
 *                        a target named <i>name</i> does not already exist, a 
 *                        new top-level window with the specified name is created, 
 *                        and the document is shown there.</tr>
 * </table> </center>
 * <p>
 * An applet viewer or browser is free to ignore <code>showDocument</code>. 
 *
 * @param   url   an absolute URL giving the location of the document.
 * @param   target   a <code>String</code> indicating where to display
 *                   the page.
 */
public void showDocument(URL url, String target) {
	if (fApplet != null) {
		AppletContext appContext = fApplet.getAppletContext();
		if (appContext != null)
			appContext.showDocument(url, target);
		else
			System.out.println("UiBrowserContext: Error AppletContext was null could not show: " + url.toString());
	}
	else
		showDocumentExternal(url);
}
/**
 * Display the document in an external web browser
 *
 * @param   url   an absolute URL giving the location of the document.
 */
protected void showDocumentExternal(URL url) {
	Runtime r= Runtime.getRuntime();
	if (fBrowserPath == null)
		setBrowserPath();
	String cmds= null;
	if (fBrowserPath.endsWith(" "))
		cmds= fBrowserPath;
	else
		cmds= fBrowserPath + " ";
	cmds += getOSSpecificUrlString(url);
	try {
		r.exec(cmds);
		return;
	}
	catch (Exception e) {
		troubleErr("showDocumentExternal(URL)", "Exception executing: >" + cmds + "</n" + e.toString());
	}
}
}
