package com.ibm.ulc.ui;

import java.awt.event.FocusEvent;
import javax.swing.*;
import java.awt.*;
import com.ibm.ulc.UIApplet.UIApplet;
public class UiJButton extends JButton {
	protected boolean fFocusTraversable= true;
	protected UIShell fShell= null;
	
/**
 * (c) Object Technology International 1997,1998.
 */
public UiJButton() {
}
/**
 * UiJButton constructor comment.
 * @param arg1 java.lang.String
 */
public UiJButton(String arg1) {
	super(arg1);
}
/**
 * UiJButton constructor comment.
 * @param arg1 java.lang.String
 * @param arg2 javax.swing.Icon
 */
public UiJButton(String arg1, javax.swing.Icon arg2) {
	super(arg1, arg2);
}
/**
 * UiJButton constructor comment.
 * @param arg1 java.lang.String
 * @param arg2 javax.swing.Icon
 * @param focusTraversable boolean
 */
public UiJButton(String arg1, Icon arg2, boolean focusTraversable) {
	super(arg1, arg2);
	fFocusTraversable= focusTraversable;
}
/**
 * UiJButton constructor comment.
 * @param arg1 javax.swing.Icon
 */
public UiJButton(javax.swing.Icon arg1) {
	super(arg1);
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
/** Answer the top level UIShell over this button (or null if there isn't any).
 *  Once a shell has been found, cache it.
 */

protected UIShell getShell() {
	if (fShell == null) {
		Container topCont = getTopLevelAncestor();
		if (topCont != null) {
			if (topCont instanceof UiJFrame)
				fShell = ((UiJFrame) topCont).getUIShell();
			else
				if (topCont instanceof UiJDialog)
					fShell = ((UiJDialog) topCont).getUIShell();
				else
					if (topCont instanceof UIApplet)
						fShell = ((UIApplet) topCont).getUIShell();
					else
						System.out.println("UiJButton.getShell container= " + topCont);
		}
	}
	return fShell;
}
//1PQRDLK: ULC:WINNT - JUI: Animated Gif cause CPU + memory usage
public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
	boolean ret = super.imageUpdate(img, flags, x, y, w, h);
	return isShowing();
}
/**
 * Identifies whether or not this component can receive the focus.
 * A disabled button, for example, would return false.
 *
 * @return true if this component can receive the focus
 */
public boolean isFocusTraversable() {
	if (fFocusTraversable) return super.isFocusTraversable();
	return false;
}
/* Process the focus event as inherited, and, if the receiver is loosing focus,
 * reset the default button.
 *
 */

protected void processFocusEvent(FocusEvent e) {
		// first do inherited processing
		super.processFocusEvent(e);

		// on top of that reset the default button
		if (e.getID()==FocusEvent.FOCUS_LOST) {
			if (getShell()!=null) {fShell.resetDefaultButton();}
		}
	}
public void setFocusTraversable(boolean focusTraversable) {
	fFocusTraversable = focusTraversable;
}
}
