package com.ibm.ulc.ui;

import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;
import javax.swing.border.EmptyBorder;
import javax.swing.*;
import java.awt.*;
import java.util.*;

/**
 * Implement the BasicToolTipUI that supports the rendering of multiple line tooltip texts.
 */
public class UiJMultiLineToolTipUI extends BasicToolTipUI {
	static UiJMultiLineToolTipUI fgSharedInstance = new UiJMultiLineToolTipUI();
	Font fSmallFont;
	static JToolTip fTip;
	protected CellRendererPane fRendererPane;
	private static JTextArea fTextArea;
public UiJMultiLineToolTipUI() {
	super();
}
public static ComponentUI createUI(JComponent c) {
	return fgSharedInstance;
}
public Dimension getMaximumSize(JComponent c) {
	return getPreferredSize(c);
}
public Dimension getMinimumSize(JComponent c) {
	return getPreferredSize(c);
}
public Dimension getPopupSize(String string, JTextArea textArea) {
	StringTokenizer st = new StringTokenizer(string, "\n");
	String longestString = "";
	int maxlen = -1;
	int lines = st.countTokens();
	FontMetrics fm = textArea.getFontMetrics(textArea.getFont());
	if (lines > 0) {
		while (st.hasMoreTokens()) {
			String s = st.nextToken();
			fm.stringWidth(s);
			int len = fm.stringWidth(s);
			if (len > maxlen) {
				maxlen = len;
				longestString = s;
			}
		}
	}
	if (lines < 1)
		lines = 1;
	if (maxlen < 1)
		maxlen = 1;
	return new Dimension(fm.stringWidth(longestString) + (fm.charWidth('M')), (fm.getHeight() * lines) + (2 * fm.getMaxDescent()));
}
public Dimension getPreferredSize(JComponent c) {
	String tipText = ((JToolTip) c).getTipText();
	if (tipText == null)
		return new Dimension(0, 0);
	fTextArea = new JTextArea(tipText);
	fTextArea.setFont(UIManager.getDefaults().getFont("ToolTip.font"));
	FontMetrics fm = fTextArea.getFontMetrics(fTextArea.getFont());
	fTextArea.setBorder(new EmptyBorder(fm.getHeight() / 4 - 1, fm.charWidth('M') / 2, 0, 0));
	fRendererPane.removeAll();
	fRendererPane.add(fTextArea);
	fTextArea.setWrapStyleWord(true);
	fTextArea.setLineWrap(true);
	Dimension size = getPopupSize(tipText, fTextArea);
	fTextArea.setSize(size);
	return size;
}
public static void initialize() {
	String key = "ToolTipUI";
	Class cls = UiJMultiLineToolTipUI.class;
	String name = cls.getName();
	UIManager.put(key, name);
	UIManager.put(name, cls);
}
public void installUI(JComponent c) {
	super.installUI(c);
	fTip = (JToolTip) c;
	fRendererPane = new CellRendererPane();
	c.add(fRendererPane);
}
public void paint(Graphics g, JComponent c) {
	Dimension size = c.getSize();
	fTextArea.setBackground(c.getBackground());
	fRendererPane.paintComponent(g, fTextArea, c, 1, 1, size.width - 1, size.height - 1, true);
}
public void uninstallUI(JComponent c) {
	super.uninstallUI(c);
	c.remove(fRendererPane);
	fRendererPane = null;
	fTextArea= null;
}
}
