package com.ibm.ulc.ui;

import java.awt.*;
import javax.swing.*;
public class UiJScrollPane extends JScrollPane {
/**
 * UiJScrollPane constructor comment.
 */
public UiJScrollPane() {
	super();
}
/**
 * UiJScrollPane constructor comment.
 * @param vsbPolicy int
 * @param hsbPolicy int
 */
public UiJScrollPane(int vsbPolicy, int hsbPolicy) {
	super(vsbPolicy, hsbPolicy);
}
/**
 * UiJScrollPane constructor comment.
 * @param view java.awt.Component
 */
public UiJScrollPane(java.awt.Component view) {
	super(view);
}
/**
 * UiJScrollPane constructor comment.
 * @param view java.awt.Component
 * @param vsbPolicy int
 * @param hsbPolicy int
 */
public UiJScrollPane(java.awt.Component view, int vsbPolicy, int hsbPolicy) {
	super(view, vsbPolicy, hsbPolicy);
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
	/**
	 * Returns a new JViewport by default.  Used to create the
	 * viewport (as needed) in <code>setViewportView</code>,
	 * <code>setRowHeaderView</code>, and <code>setColumnHeaderView</code>.
	 * Subclasses may override this method to return a subclass of JViewport.
	 *
	 * @return a JViewport
	 */
	protected JViewport createViewport() {
		return new UiJViewport();
	}
public Dimension getMinimumSize() {
	return getPreferredSize();
}
public void setCursor(Cursor cursor) {
	super.setCursor(cursor);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setCursor(cursor);
	}
}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
	Component parent = getParent();
	if (parent != null) {
		parent.repaint();
	}
}
public void setToolTipText(String text) {
	super.setToolTipText(text);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		if (c instanceof JComponent)
			((JComponent)c).setToolTipText(text);
	}
}
}
