package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.text.*;
import com.ibm.ulc.ui.UIField;
import com.ibm.ulc.ui.lists.UiCellEditor;

public class UiPlainDocument extends PlainDocument {
	protected UIField fTextField;
	protected UiCellEditor fCellEditor;
public UiPlainDocument() {
}
public UiPlainDocument(UiCellEditor cellEditor) {
	fCellEditor = cellEditor;
	fTextField = null;
}
public UiPlainDocument(UIField field) {
	fTextField = field;
	fCellEditor = null;
}
public void free() {
	 fTextField= null;
	 fCellEditor= null;
}
/**
 * This method was created by a SmartGuide.
 * @param arg1 int
 * @param arg2 java.lang.String
 * @param arg3 javax.swing.text.AttributeSet
 * @exception javax.swing.text.BadLocationException The exception description.
 */
public void insertString(int position, String newString, AttributeSet attribute) throws BadLocationException {
	String ret;
	if (fTextField != null)
		ret = fTextField.filterInput(position, newString, attribute);
	else
		ret = fCellEditor.filterInput(position, newString, attribute);
	if (ret != null)
		super.insertString(position, ret, attribute);
}
public void remove(int start, int end) throws BadLocationException {
	super.remove(start, end);
}
}
