package com.ibm.ulc.ui.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.peer.*;

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcObject;
import com.ibm.ulc.util.UlcConsole;
import com.ibm.ulc.comm.*;


/**
 * The AWTRequestProcessor wraps our events and posts them into AWT's
 * standard event queue.
 */
public class AWTRequestProcessor extends UlcObject implements IRequestProcessor {
	private EventQueue fQueue= null;
	public AWTRequestProcessor() {
		Toolkit tk= Toolkit.getDefaultToolkit();
		if (tk != null) {
			fQueue= tk.getSystemEventQueue();
			if (fQueue == null)
	    		trouble("AWTRequestProcessor", "couldn't get EventQueue");
	    } else
	    	trouble("AWTRequestProcessor", "couldn't get Toolkit");
	}
	public void addRequest(Request request) {
		if (request != null && fQueue != null)
			fQueue.postEvent(new AWTRequest(request));
	}
}
