package com.ibm.ulc.ui.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.ui.UIComponent;

public interface IEnableListener {
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
void addEnableListener(IEnableListenerTarget c);
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
void removeEnableListener(IEnableListenerTarget c);
/**
 * Return true if the component for which I am an enabler should be enabled.
 *
 */
boolean shouldEnableListener();
}
