package com.ibm.ulc.ui.base;

/**
 * (c) Object Technology International 1997,1998.
 */
import java.net.*;
import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.util.Vector;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.UI;

public class ULCOrbMonitor extends JFrame implements java.awt.event.WindowListener, MouseListener, java.awt.event.ActionListener, ListSelectionListener, IConnectionController, IRequestListener {
	private Object fCriticalSection = null;
	private int fSentEvents = 0;
	private int fSentRequests = 0;
	private int fReceivedRequests = 0;
	private long fSentBytes = 0;
	private long fReceivedBytes = 0;
	private JList fConnectionsList = null;
	private JLabel fSentEventsLabel;
	private JLabel fSentRequestsLabel;
	private JLabel fReceivedRequestsLabel;
	private JLabel fReceivedBytesLabel;
	private JLabel fSentBytesLabel;
	private JLabel fAverageReceivedBytesLabel;
	private JLabel fAverageSentBytesLabel;
	private JButton fLoggingButton;
	private JButton fStopUIButton;
	private JButton fResetButton;
	private boolean fLogging = false;
	private UI fUI = null;
	private ULCOrbMonitorEntry fSelectedEntry = null;
	private DefaultListModel fListModel = null;
	private MenuItem fTerminateMenuItem, fCopyToClipboardMenuItem;
	private String fConnectionLabel= "";
	private TitledBorder fBorder=null;
	private JPanel fBorderPanel= null;
/**
 * ULCOrbMonitor constructor comment.
 */
public ULCOrbMonitor(UI ui) {
	super();
	setUI(ui);
	initialize();
}
/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */

public void actionPerformed(java.awt.event.ActionEvent e) {
	if (e.getSource() == fStopUIButton) {
		stopUI();
		return;
	}
	if (e.getSource() == fResetButton) {
		resetCounters();
		return;
	}
	if (e.getSource() == fLoggingButton) {
		toggleLogging();
		return;
	}
	if (e.getSource() == fTerminateMenuItem) {
		terminateConnection();
		return;
	}
	if (e.getSource() == fCopyToClipboardMenuItem) {
		copyReportToClipboard();
		return;
	}
}
public void connectionCreated(IConnection connection) {
	synchronized (fCriticalSection) {
		try {
			connection.addRequestListener(this);
			final ULCOrbMonitorEntry entry = new ULCOrbMonitorEntry(connection, ((UlcConnection) connection).getLocalUrlString());
			Runnable r = new Runnable() {
				public void run() {
					fListModel.addElement(entry);
				}
			};
			SwingUtilities.invokeLater(r);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
public void connectionEnded(IConnection connection, UlcTransportException ex) {
	removeConnection(connection);
}
public void connectionStarted(IConnection conn, UlcTransportException ex) {
	final IConnection connection = conn;
	if (ex != null) {
		removeConnection(connection);
		return;
	}
	synchronized (fCriticalSection) {
		try {
			Runnable r = new Runnable() {
				public void run() {
					int size = fListModel.getSize();
					for (int i = 0; i < size; i++) {
						ULCOrbMonitorEntry entry = (ULCOrbMonitorEntry) fListModel.elementAt(i);
						if (entry.fConnection == connection) {
							entry.fLabel = ((UlcConnection) connection).getRemoteUrlString();
							fListModel.setElementAt(entry, i);
						}
					}
				}
			};
			SwingUtilities.invokeLater(r);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
/**
 * Writes the current statistics into the clipboard
 */
public void copyReportToClipboard() {
	char[] crlf = {'\r', '\n'};
	try {
		java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
		StringBuffer report = new StringBuffer();
		report.append(crlf);
		report.append("**************************************************************");
		report.append(crlf);
		report.append(getResourceString("LblOrbSnapshot"));
		report.append(new java.util.Date().toString());
		report.append(crlf);
		report.append(getVersionTooltipText());
		report.append(crlf);
		report.append(getResourceString("LblSentRequests"));
		report.append(fSentRequests);
		report.append(crlf);
		report.append(getResourceString("LblSentEvents"));
		report.append(fSentEvents);
		report.append(crlf);
		report.append(getResourceString("LblRecvRequests"));
		report.append(fReceivedRequests);
		report.append(crlf);
		report.append(getResourceString("LblSentBytes"));
		report.append(fSentBytes);
		report.append(crlf);
		report.append(getResourceString("LblRecvBytes"));
		report.append(fReceivedBytes);
		report.append(crlf);
		report.append(getResourceString("LblAvgSendSize"));
		report.append(getAverageSendSize());
		report.append(crlf);
		report.append(getResourceString("LblAvgRecvSize"));
		report.append(getAverageReceivedSize());
		report.append(crlf);
		report.append(getResourceString("LblActiveConnections"));
		report.append(fListModel.getSize());
		report.append(crlf);
		report.append("**************************************************************");
		report.append(crlf);
		clipboard.setContents(new StringSelection(report.toString()), null);
	}
	catch (Exception e) {
	}
}
private JPanel createButtonsPanel() {
	GridBagLayout gl = new GridBagLayout();
	JPanel buttons = new JPanel(false);
	buttons.setLayout(gl);
	buttons.setToolTipText(getVersionTooltipText());
	fStopUIButton = new JButton(getResourceString("ButStopUI"));
	fStopUIButton.setToolTipText(getResourceString("TTxtStopUI"));
	fStopUIButton.addActionListener(this);
	fLoggingButton = new JButton(getResourceString("ButLoggingOn"));
	fLoggingButton.setToolTipText(getResourceString("TTxtLoggingOn"));
	fLoggingButton.addActionListener(this);
	fResetButton = new JButton(getResourceString("ButReset"));
	fResetButton.setToolTipText(getResourceString("TTxtReset"));
	fResetButton.addActionListener(this);
	JLabel dummy = new JLabel(" ");
	buttons.add(dummy);
	gl.setConstraints(dummy, createConstraints("ee", 0, 1, 1, 1));
	buttons.add(fStopUIButton);
	gl.setConstraints(fStopUIButton, createConstraints("cc", 1, 1, 2, 1));
	dummy = new JLabel(" ");
	buttons.add(dummy);
	gl.setConstraints(dummy, createConstraints("ee", 3, 1, 1, 1));
	buttons.add(fLoggingButton);
	gl.setConstraints(fLoggingButton, createConstraints("cc", 4, 1, 2, 1));
	dummy = new JLabel(" ");
	buttons.add(dummy);
	gl.setConstraints(dummy, createConstraints("ee", 6, 1, 1, 1));
	buttons.add(fResetButton);
	gl.setConstraints(fResetButton, createConstraints("cb", 7, 1, 2, 1));
	dummy = new JLabel(" ");
	buttons.add(dummy);
	gl.setConstraints(dummy, createConstraints("ee", 9, 1, 1, 1));
	return buttons;
}
private GridBagConstraints createConstraints(String alignmentString, int x, int y, int spanX, int spanY) {
	GridBagConstraints constraints = new GridBagConstraints();
	if (x == -1)
		x = GridBagConstraints.RELATIVE;
	if (y == -1)
		y = GridBagConstraints.RELATIVE;
	constraints.gridx = x;
	constraints.gridy = y;
	constraints.weightx = 0.0;
	constraints.weighty = 0.0;
	constraints.gridwidth = spanX;
	constraints.gridheight = spanY;
	int i = 0;
	switch (alignmentString.charAt(0)) {
		case 'e' :
		case 'f' :
			i = 0;
			constraints.weightx = 1.0;
			break;
		case 'l' :
			i = 1;
			break;
		case 'c' :
			i = 2;
			break;
		case 'r' :
			i = 3;
			break;
	}
	switch (alignmentString.charAt(1)) {
		case 'e' :
		case 'f' :
			i = i * 4 + 0;
			constraints.weighty = 1.0;
			break;
		case 't' :
			i = i * 4 + 1;
			break;
		case 'c' :
		case 'B' :
			i = i * 4 + 2;
			break;
		case 'b' :
			i = i * 4 + 3;
			break;
	}
	switch (i) {
		case 0 :
			constraints.fill = GridBagConstraints.BOTH;
			break;
		case 1 :
			constraints.fill = GridBagConstraints.HORIZONTAL;
			constraints.anchor = GridBagConstraints.NORTH;
			break;
		case 2 :
			constraints.fill = GridBagConstraints.HORIZONTAL;
			break;
		case 3 :
			constraints.fill = GridBagConstraints.HORIZONTAL;
			constraints.anchor = GridBagConstraints.SOUTH;
			break;
		case 4 :
			constraints.fill = GridBagConstraints.VERTICAL;
			constraints.anchor = GridBagConstraints.WEST;
			break;
		case 5 :
			constraints.anchor = GridBagConstraints.NORTHWEST;
			break;
		case 6 :
			constraints.anchor = GridBagConstraints.WEST;
			break;
		case 7 :
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			break;
		case 8 :
			constraints.fill = GridBagConstraints.VERTICAL;
			break;
		case 9 :
			constraints.anchor = GridBagConstraints.NORTH;
			break;
		case 10 :
			break;
		case 11 :
			constraints.anchor = GridBagConstraints.SOUTH;
			break;
		case 12 :
			constraints.fill = GridBagConstraints.VERTICAL;
			constraints.anchor = GridBagConstraints.EAST;
			break;
		case 13 :
			constraints.anchor = GridBagConstraints.NORTHEAST;
			break;
		case 14 :
			constraints.anchor = GridBagConstraints.EAST;
			break;
		case 15 :
			constraints.anchor = GridBagConstraints.SOUTHEAST;
			break;
	}
	return constraints;
}
private JPanel createListPanel() {
	fBorderPanel = new JPanel(false);
	fListModel = new DefaultListModel();
	fConnectionsList = new JList(fListModel);
	fBorder = BorderFactory.createTitledBorder("Connections");
	fBorder.setTitleFont(new java.awt.Font("dialog", 1, 16));
	fConnectionLabel = getResourceString("LblConnections");
	fBorder.setTitle(fConnectionLabel);
	fBorderPanel.setBorder(fBorder);
	fConnectionsList.setFixedCellWidth(getInitialSize().width / 2);
	JScrollPane scrollPane = new JScrollPane(fConnectionsList);
	scrollPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
	scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
	scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	fBorderPanel.add(scrollPane);
	GridBagLayout gl = new GridBagLayout();
	fBorderPanel.setLayout(gl);
	gl.setConstraints(scrollPane, createConstraints("ee", 0, 0, 1, 1));
	fConnectionsList.addMouseListener(this);
	fConnectionsList.addListSelectionListener(this);
	return fBorderPanel;
}
private void createOrbPanel() {
	GridBagLayout gl = new GridBagLayout();
	Container orbPanel = getContentPane();
	((JPanel) orbPanel).setDoubleBuffered(false);
	orbPanel.setLayout(gl);
	orbPanel.setName("OrbPanel");
	//
	JPanel conn = createListPanel();
	conn.setDoubleBuffered(false);
	GridBagConstraints c = createConstraints("ee", 0, 0, 6, 11);
	c.weightx = 0.4;
	gl.setConstraints(conn, c);
	orbPanel.add(conn);
	//
	JPanel report = createReportPanel();
	report.setDoubleBuffered(false);
	c = createConstraints("ee", 6, 0, 14, 11);
	gl.setConstraints(report, c);
	orbPanel.add(report);
	//
	JPanel buttons = createButtonsPanel();
	buttons.setDoubleBuffered(false);
	gl.setConstraints(buttons, createConstraints("ec", 0, 11, 20, 2));
	orbPanel.add(buttons);
}
private JPanel createReportPanel() {
	JPanel border = new JPanel(false);
	TitledBorder b = BorderFactory.createTitledBorder("Communication");
	b.setTitleFont(new java.awt.Font("dialog", 1, 16));
	b.setTitle(getResourceString("LblCommunication"));
	border.setBorder(b);
	JPanel report = new JPanel(false);
	report.setToolTipText(getVersionTooltipText());
	JLabel sentRequestsLabel = new JLabel(getResourceString("LblSentRequests"));
	sentRequestsLabel.setToolTipText(getResourceString("TTxtSentRequests"));
	JLabel recvRequestsLabel = new JLabel(getResourceString("LblRecvRequests"));
	recvRequestsLabel.setToolTipText(getResourceString("TTxtRecvRequests"));
	JLabel sentBytesLabel = new JLabel(getResourceString("LblSentBytes"));
	sentBytesLabel.setToolTipText(getResourceString("TTxtSentBytes"));
	JLabel recvBytesLabel = new JLabel(getResourceString("LblRecvBytes"));
	recvBytesLabel.setToolTipText(getResourceString("TTxtRecvBytes"));
	JLabel sentEventsLabel = new JLabel(getResourceString("LblSentEvents"));
	sentEventsLabel.setToolTipText(getResourceString("TTxtSentEvents"));
	JLabel avgSentLabel = new JLabel(getResourceString("LblAvgSendSize"));
	avgSentLabel.setToolTipText(getResourceString("TTxtAvgSendSize"));
	JLabel avgRecvLabel = new JLabel(getResourceString("LblAvgRecvSize"));
	avgRecvLabel.setToolTipText(getResourceString("TTxtAvgRecvSize"));
	fSentRequestsLabel = new JLabel("Num:");
	fReceivedRequestsLabel = new JLabel("Num:");
	fSentBytesLabel = new JLabel("Num:");
	fReceivedBytesLabel = new JLabel("Num:");
	fSentEventsLabel = new JLabel("Num:");
	fAverageReceivedBytesLabel = new JLabel("Num:");
	fAverageSentBytesLabel = new JLabel("Num:");
	//
	GridBagLayout gl = new GridBagLayout();
	report.setLayout(gl);
	//
	gl.setConstraints(sentRequestsLabel, createConstraints("rc", 0, 0, 5, 2));
	report.add(sentRequestsLabel);
	//
	fSentRequestsLabel.setHorizontalAlignment(JLabel.RIGHT);
	gl.setConstraints(fSentRequestsLabel, createConstraints("ec", 5, 0, 5, 2));
	report.add(fSentRequestsLabel);
	//
	gl.setConstraints(sentEventsLabel, createConstraints("rc", 0, 2, 5, 2));
	report.add(sentEventsLabel);
	//
	fSentEventsLabel.setHorizontalAlignment(JLabel.RIGHT);
	gl.setConstraints(fSentEventsLabel, createConstraints("ec", 5, 2, 5, 2));
	report.add(fSentEventsLabel);
	//
	gl.setConstraints(recvRequestsLabel, createConstraints("rc", 0, 4, 5, 2));
	report.add(recvRequestsLabel);
	//
	fReceivedRequestsLabel.setHorizontalAlignment(JLabel.RIGHT);
	gl.setConstraints(fReceivedRequestsLabel, createConstraints("ec", 5, 4, 5, 2));
	report.add(fReceivedRequestsLabel);
	//
	gl.setConstraints(sentBytesLabel, createConstraints("rc", 0, 6, 5, 2));
	report.add(sentBytesLabel);
	//
	fSentBytesLabel.setHorizontalAlignment(JLabel.RIGHT);
	gl.setConstraints(fSentBytesLabel, createConstraints("ec", 5, 6, 5, 2));
	report.add(fSentBytesLabel);
	//
	gl.setConstraints(recvBytesLabel, createConstraints("rc", 0, 8, 5, 2));
	report.add(recvBytesLabel);
	//
	fReceivedBytesLabel.setHorizontalAlignment(JLabel.RIGHT);
	gl.setConstraints(fReceivedBytesLabel, createConstraints("ec", 5, 8, 5, 2));
	report.add(fReceivedBytesLabel);
	//
	gl.setConstraints(avgSentLabel, createConstraints("rc", 0, 10, 5, 2));
	report.add(avgSentLabel);
	//
	gl.setConstraints(fAverageSentBytesLabel, createConstraints("ec", 5, 10, 5, 2));
	report.add(fAverageSentBytesLabel);
	fAverageSentBytesLabel.setHorizontalAlignment(JLabel.RIGHT);
	//
	gl.setConstraints(avgRecvLabel, createConstraints("rc", 0, 12, 5, 2));
	report.add(avgRecvLabel);
	//
	gl.setConstraints(fAverageReceivedBytesLabel, createConstraints("ec", 5, 12, 5, 2));
	report.add(fAverageReceivedBytesLabel);
	fAverageReceivedBytesLabel.setHorizontalAlignment(JLabel.RIGHT);
	//
	gl = new GridBagLayout();
	border.setLayout(gl);
	border.add(report);
	gl.setConstraints(report, createConstraints("ee", 0, 0, 1, 1));
	return border;
}
private long getAverageReceivedSize() {
	return fReceivedBytes / fReceivedRequests;
}
private long getAverageSendSize() {
	return fSentBytes / (fSentRequests + fSentEvents);
}
private Dimension getInitialSize() {
	return new Dimension(450, 300);
}
/**
 * Gets a string from the specified ResourceBundle.
 * The resourceBundle is identified by the <code>getResourceBundleBaseFileName</code>
 * Subclasses must implement <code>getResourceBundleBaseFileName</code> if they
 * are using this method to retrieve the correct String for the specified locale.
 * The locale used will be by default the locale of the UI Engine.
 * If subclasses want to override the locale used they can implement 
 * the method <code>getResourceLocale</code>
 *
 * @param key <code>String</code> lookup key.
 * @return <code>String</code>
 * @see getResourceBundleBaseFileName
 * @see getResourceLocale
 */
public String getResourceString(String key) {
	return getUI().getResourceString(key);
}
public UI getUI() {
	return fUI;
}
private String getVersionTooltipText() {
	return getUI().getResourceString("LblULCVersion") + Common.getUlcVersion() + " , " + getUI().getResourceString("LblProtocolVersion") + Common.getVersion();
}
private void initialize() {
	fCriticalSection = new Object();
	setName("UIORBMonitor");
	setSize(getInitialSize());
	setTitle(getResourceString("LblUlcOrbMonitor"));
	createOrbPanel();
	updateCounters();
	addWindowListener(this);
}
/**
 * Invoked when the mouse has been clicked on a component.
 */
public void mouseClicked(MouseEvent e) {
}
/**
 * Invoked when the mouse enters a component.
 */
public void mouseEntered(MouseEvent e) {
}
/**
 * Invoked when the mouse exits a component.
 */
public void mouseExited(MouseEvent e) {
}
/**
 * Invoked when a mouse button has been pressed on a component.
 */
public void mousePressed(MouseEvent e) {
}
/**
 * Invoked when a mouse button has been released on a component.
 */
public void mouseReleased(MouseEvent e) {
	if (e.isPopupTrigger()) {
		if (e.getSource() == fConnectionsList)
			showPopup(e);
		else
			showReportPopup(e);
	}
}
public synchronized void receivedRequest(UlcConnection conn, Request request) {
	try {
		fReceivedRequests++;
		fReceivedBytes = fReceivedBytes + ((ORBRequest) request).getByteCount();
		conn.postRequest(new UpdateCountersRequest(this));
	}
	catch (Exception e) {
		e.printStackTrace();
	}
}
void removeConnection(IConnection conn) {
	final IConnection connection = conn;
	synchronized (fCriticalSection) {
		try {
			connection.removeRequestListener(this);
			Runnable r = new Runnable() {
				public void run() {
					int size = fListModel.getSize();
					for (int i = 0; i < size; i++) {
						ULCOrbMonitorEntry entry = (ULCOrbMonitorEntry) fListModel.elementAt(i);
						if (entry.fConnection == connection) {
							fListModel.removeElement(entry);
							if (fListModel.isEmpty() && !getUI().isServerMode() && !getUI().isAutoReconnectOn() && !getUI().isServerInClientReconnectMode())
								stopUI();
							repaint();
							return;
						}
					}
				}
			};
			SwingUtilities.invokeLater(r);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
public void resetCounters() {
	fSentEvents = 0;
	fSentRequests = 0;
	fSentBytes = 0;
	fReceivedBytes = 0;
	fReceivedRequests = 0;
	resetLabel(fSentRequestsLabel);
	resetLabel(fSentRequestsLabel);
	resetLabel(fSentEventsLabel);
	resetLabel(fReceivedRequestsLabel);
	resetLabel(fSentBytesLabel);
	resetLabel(fReceivedBytesLabel);
	updateCounters();
	return;
}
private void resetLabel(Label label) {
	label.setText("");
	Component parent = label.getParent(); //1EKNZV6
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
	}
}
private void resetLabel(JLabel label) {
	label.setText("");
	Component parent = label.getParent(); //1EKNZV6
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
	}
}
public synchronized void sentRequest(UlcConnection conn, Request request) {
	try {
		ORBRequest req = (ORBRequest) request;
		if (req.getData().get("req", "event").equals("event")) {
			fSentEvents++;
		}
		else
			fSentRequests++;
		fSentBytes = fSentBytes + req.getByteCount();
		conn.postRequest(new UpdateCountersRequest(this));
	}
	catch (Exception e) {
		e.printStackTrace();
	}
}
public void setUI(UI ui) {
	fUI= ui;
}
/**
 * Invoked when a mouse button has been released on a component.
 */
public void showPopup(MouseEvent e) {
	java.awt.Component popupOwner = e.getComponent();
	if (popupOwner != null) {
		PopupMenu popup = new PopupMenu("Connection Popup");
		fTerminateMenuItem = new MenuItem(getResourceString("LblTerminate"));
		popup.add(fTerminateMenuItem);
		fTerminateMenuItem.addActionListener(this);
		popupOwner.add(popup);
		if (fSelectedEntry == null)
			fTerminateMenuItem.setEnabled(false);
		popup.show(e.getComponent(), e.getX(), e.getY());
	}
}
/**
 * Invoked when a mouse button has been released on a component.
 */
public void showReportPopup(MouseEvent e) {
	java.awt.Component popupOwner = e.getComponent();
	if (popupOwner != null) {
		PopupMenu popup = new PopupMenu("Copy to Clipboard");
		fCopyToClipboardMenuItem = new MenuItem(getResourceString("LblCopyToClipboard"));
		popup.add(fCopyToClipboardMenuItem);
		fCopyToClipboardMenuItem.addActionListener(this);
		popupOwner.add(popup);
		popup.show(e.getComponent(), e.getX(), e.getY());
	}
}
public void stopUI() {
	setVisible(false);
	dispose();
	getUI().stopServer();	
	if (!getUI().isApplet())
		System.exit(1);
}
/**
 * Invoked when the list is selected to terminate the selected connection
 */
public void terminateConnection() {
	if (fSelectedEntry != null) {
		((ORBConnection) fSelectedEntry.fConnection).close();
		fSelectedEntry= null;
		fConnectionsList.setSelectedIndex(-1);
	}
}
public void toggleLogging() {
	String newLabel;
	fLogging = !fLogging;
	if (fLogging) {
		newLabel = getResourceString("ButLoggingOff");
		fLoggingButton.setToolTipText(getResourceString("TTxtLoggingOff"));
	} else {
		newLabel = getResourceString("ButLoggingOn");
		fLoggingButton.setToolTipText(getResourceString("TTxtLoggingOn"));
	}
	fLoggingButton.setText(newLabel);
	getUI().setLoggingEnabled(fLogging);
}
public void updateCounters() {
	fSentRequestsLabel.setText(Integer.toString(fSentRequests));
	fSentEventsLabel.setText(Integer.toString(fSentEvents));
	fReceivedRequestsLabel.setText(Integer.toString(fReceivedRequests));
	fSentBytesLabel.setText(Long.toString(fSentBytes));
	fReceivedBytesLabel.setText((Long.toString(fReceivedBytes)));
	if (fReceivedRequests == 0) {
		fAverageReceivedBytesLabel.setText("0");
	}
	else {
		fAverageReceivedBytesLabel.setText(String.valueOf(getAverageReceivedSize()));
	}
	if ((fSentRequests == 0) && (fSentEvents == 0)) {
		fAverageSentBytesLabel.setText("0");
	}
	else {
		fAverageSentBytesLabel.setText(String.valueOf(getAverageSendSize()));
	}
}
/**
 * Invoked when the list is selected
 */
public void valueChanged(ListSelectionEvent e) {
	if (fConnectionsList == null)
		return;
	try {
		fSelectedEntry = (ULCOrbMonitorEntry) fConnectionsList.getSelectedValue();
	} catch (Exception ex) {
		return;
	};
	if (fSelectedEntry != null) {
		String text = fSelectedEntry.fLabel;
		if (text == null)
			return;
		if (text.length() > 100) {
			text = text.substring(0, 100);
			text = text + "...";
		}
		fConnectionsList.setToolTipText(text);
	} else {
		fConnectionsList.setToolTipText(null);
	}
}
public void windowActivated(java.awt.event.WindowEvent e) {
}
public void windowClosed(java.awt.event.WindowEvent e) {
}
public void windowClosing(java.awt.event.WindowEvent e) {
	if ((e.getSource() == this))
		stopUI();
}
public void windowDeactivated(java.awt.event.WindowEvent e) {
}
public void windowDeiconified(java.awt.event.WindowEvent e) {
}
public void windowIconified(java.awt.event.WindowEvent e) {
}
public void windowOpened(java.awt.event.WindowEvent e) {
}
}
