package com.ibm.ulc.ui.dataTypes;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

public class DataTypeConversionException extends Exception {
	/**
	 * The value that will be returned when getValue is called on this exception.
	 *
	 * @serial
	 */
	protected Object fValue = null;
/**
 * DataTypeConversionError is an exception that is thrown if the
 * input String cannot be converted to the data type specified.
 */
public DataTypeConversionException() {
	super();
}
/**
 * DataTypeConversionError is an exception that is thrown if the
 * input String cannot be converted to the data type specified.
 *
 * @param value The value to be returned in the exception when the getValue is called.
 */
public DataTypeConversionException(Object value) {
	fValue= value;
}
/**
 * DataTypeConversionError is an exception that is thrown if the
 * input String cannot be converted to the data type specified.
 *
 * @param s java.lang.String The description of the exception
 */
public DataTypeConversionException(String s) {
	super(s);
}
/**
 * DataTypeConversionError is an exception that is thrown if the
 * input String cannot be converted to the data type specified.
 *
 * @param value The value to be returned in the exception when the getValue is called.
 * @param s java.lang.String The description of the exception
 */
public DataTypeConversionException(String s, Object value) {
	super(s);
	fValue = value;
}
/**
 * Returns the currently specified default value to be returned on an exception.
 */
public Object getValue() {
	return fValue;
}
}
