package com.ibm.ulc.ui.dataTypes;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.lang.reflect.*;
/**
 * Implement a IRegularExpression validator that accepts all input
 */
public class DummyRegularExpression implements IRegularExpression {
	protected Object regExInstance;
/**
 * Create an instance of this widget with the specified expression
 *
 * @param expression The String regular expression
 */
public DummyRegularExpression(String expression) {
	super();
	regExInstance = newInstance("COM.stevesoft.pat.Regex", expression); //Case sensitive path
}
/**
 * Call the <code>matchAt</code> method using reflection.
 * Return true if the matchString conforms to the configured regular expression
 *
 * @param matchString 	The input String that is matched agains the regular expression
 * @param start  		The index at which the comparison should start
 */
protected boolean invokeMatchAt(String matchString, int start) {
	try {
		Class[] parameterTypes = new Class[2];
		parameterTypes[0] = String.class;
		parameterTypes[1] = int.class;
		Method m = regExInstance.getClass().getMethod("matchAt", parameterTypes);
		Object[] parameters = new Object[2];
		parameters[0] = matchString;
		parameters[1] = new Integer(start);
		return ((Boolean) m.invoke(regExInstance, parameters)).booleanValue();
	} catch (IllegalArgumentException e) {
		System.out.println("DummyRegularExpression.invokeMatchAt got IllegalArgumentException");
	} catch (InvocationTargetException e) {
		System.out.println("DummyRegularExpression.invokeMatchAt got InvocationTargetException");
	} catch (NoSuchMethodException e) {
		System.out.println("DummyRegularExpression.invokeMatchAt got NoSuchMethodException");
	} catch (IllegalAccessException e) {
		System.out.println("DummyRegularExpression.invokeMatchAt got IllegalAccessException");
	}
	return true;
}
/**
 * Call the stringMatched method using reflection, return the resulting string or null
 *
 */
protected String invokeStringMatched() {
	try {
		java.lang.reflect.Method m = regExInstance.getClass().getMethod("stringMatched", null);
		return (String) m.invoke(regExInstance, null);
	} catch (IllegalArgumentException e) {
		System.out.println("DummyRegularExpression.invokeStringMatched got IllegalArgumentException");
	} catch (InvocationTargetException e) {
		System.out.println("DummyRegularExpression.invokeStringMatched got InvocationTargetException");
	} catch (NoSuchMethodException e) {
		System.out.println("DummyRegularExpression.invokeStringMatched got NoSuchMethodException");
	} catch (IllegalAccessException e) {
		System.out.println("DummyRegularExpression.invokeStringMatched got IllegalAccessException");
	}
	return "";
}
/** 
 * Return true if the matchString conforms to the configured regular expression
 *
 * @param matchString 	The input String that is matched agains the regular expression
 * @param start  		The index at which the comparison should start
 */
public boolean matchAt(String matchString, int start) {
	if (regExInstance != null)
		return invokeMatchAt(matchString, start);
	return true;
}
public static Object newInstance (String type, String expression ) {
	Class[] parameterTypes;
	Object[] parameters;
	try {
		Class cl= Class.forName(type);
		parameterTypes= new Class[1];
		parameterTypes[0]= String.class;
		Constructor ctor= cl.getDeclaredConstructor(parameterTypes);
		parameters= new Object[1];
		parameters[0]= expression;
		Object inst= ctor.newInstance(parameters);
		if (inst != null)
			return inst;
		System.out.println("DummyRegularExpression.newInstance couldn't find " + type);
		return null;
	} catch (InvocationTargetException e) {
		System.out.println("DummyRegularExpression.newInstance InvocationTargetException ("+type+")");
	} catch (NoSuchMethodException e) {
		System.out.println("DummyRegularExpression.newInstance NoSuchMethodException ("+type+")");
	} catch (ClassNotFoundException e) {
		System.out.println("DummyRegularExpression.newInstance ClassNotFoundException ("+type+")");
	} catch (InstantiationException e) {
		System.out.println("DummyRegularExpression.newInstance InstantiationException  ("+type+")");
	} catch (IllegalAccessException e) {
		System.out.println("DummyRegularExpression.newInstance IllegalAccessException  ("+type+")");
	} catch (ClassCastException e) {
	}
	return null;
}
/**
 * Return the matching string or null
 * Note: In this implementation we return an empty string if the regular expression
 * instance could not be created. This will allow all input to be accepted if the
 * regular expression implementation classes were not found.
 */
public String stringMatched() {
	if (regExInstance != null)
		return invokeStringMatched();
	return "";
}
}
